/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.util.Objects;
import org.opentripplanner.routing.api.request.framework.Units;
import org.opentripplanner.routing.api.request.preference.AccessibilityPreferences;

public record WheelchairPreferences(AccessibilityPreferences trip, AccessibilityPreferences stop, AccessibilityPreferences elevator, double inaccessibleStreetReluctance, double maxSlope, double slopeExceededReluctance, double stairsReluctance) {
    private static final int DEFAULT_INACCESSIBLE_STREET_RELUCTANCE = 25;
    private static final double DEFAULT_MAX_SLOPE = 0.083;
    private static final int DEFAULT_SLOPE_EXCEEDED_RELUCTANCE = 1;
    private static final int DEFAULT_STAIRS_RELUCTANCE = 100;
    private static final AccessibilityPreferences DEFAULT_ELEVATOR_FEATURE = AccessibilityPreferences.ofCost(20, 3600);
    public static final WheelchairPreferences DEFAULT = new WheelchairPreferences(AccessibilityPreferences.ofOnlyAccessible(), AccessibilityPreferences.ofOnlyAccessible(), DEFAULT_ELEVATOR_FEATURE, 25.0, 0.083, 1.0, 100.0);

    public WheelchairPreferences(AccessibilityPreferences trip, AccessibilityPreferences stop, AccessibilityPreferences elevator, double inaccessibleStreetReluctance, double maxSlope, double slopeExceededReluctance, double stairsReluctance) {
        this.trip = Objects.requireNonNull(trip);
        this.stop = Objects.requireNonNull(stop);
        this.elevator = Objects.requireNonNull(elevator);
        this.inaccessibleStreetReluctance = Units.reluctance(inaccessibleStreetReluctance);
        this.maxSlope = Units.ratio(maxSlope);
        this.slopeExceededReluctance = Units.reluctance(slopeExceededReluctance);
        this.stairsReluctance = Units.reluctance(stairsReluctance);
    }
}

