/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.routing.algorithm.transferoptimization.api.TransferOptimizationParameters;
import org.opentripplanner.routing.api.request.framework.Units;
import org.opentripplanner.routing.api.request.preference.TransferOptimizationPreferences;
import org.opentripplanner.util.lang.DoubleUtils;
import org.opentripplanner.util.lang.ToStringBuilder;

public final class TransferPreferences
implements Serializable {
    public static final TransferPreferences DEFAULT = new TransferPreferences();
    private static final int MAX_NUMBER_OF_TRANSFERS = 30;
    private final int cost;
    private final int slack;
    private final double waitReluctance;
    private final int maxTransfers;
    private final TransferOptimizationParameters optimization;
    private final int nonpreferredCost;

    private TransferPreferences() {
        this.cost = 0;
        this.slack = 120;
        this.waitReluctance = 1.0;
        this.maxTransfers = 12;
        this.optimization = TransferOptimizationPreferences.DEFAULT;
        this.nonpreferredCost = 180;
    }

    private TransferPreferences(Builder builder) {
        this.cost = Units.cost(builder.cost);
        this.slack = Units.duration(builder.slack);
        this.waitReluctance = Units.reluctance(builder.waitReluctance);
        this.maxTransfers = Units.count(builder.maxTransfers, 30);
        this.optimization = Objects.requireNonNull(builder.optimization);
        this.nonpreferredCost = Units.cost(builder.nonpreferredCost);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public int cost() {
        return this.cost;
    }

    public int slack() {
        return this.slack;
    }

    public double waitReluctance() {
        return this.waitReluctance;
    }

    public Integer maxTransfers() {
        return this.maxTransfers;
    }

    public TransferOptimizationParameters optimization() {
        return this.optimization;
    }

    public int nonpreferredCost() {
        return this.nonpreferredCost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferPreferences that = (TransferPreferences)o;
        return this.cost == that.cost && this.slack == that.slack && DoubleUtils.doubleEquals(that.waitReluctance, this.waitReluctance) && this.maxTransfers == that.maxTransfers && this.optimization.equals(that.optimization) && this.nonpreferredCost == that.nonpreferredCost;
    }

    public int hashCode() {
        return Objects.hash(this.cost, this.slack, this.waitReluctance, this.maxTransfers, this.optimization, this.nonpreferredCost);
    }

    public String toString() {
        return ToStringBuilder.of(TransferPreferences.class).addNum("cost", (Number)this.cost, TransferPreferences.DEFAULT.cost).addNum("slack", (Number)this.slack, TransferPreferences.DEFAULT.slack).addNum("waitReluctance", (Number)this.waitReluctance, TransferPreferences.DEFAULT.waitReluctance).addNum("maxTransfers", (Number)this.maxTransfers, TransferPreferences.DEFAULT.maxTransfers).addObj("optimization", this.optimization, TransferPreferences.DEFAULT.optimization).addNum("nonpreferredCost", (Number)this.nonpreferredCost, TransferPreferences.DEFAULT.nonpreferredCost).toString();
    }

    public static class Builder {
        private final TransferPreferences original;
        private int cost = 0;
        private int slack = 120;
        private int nonpreferredCost = 180;
        private double waitReluctance = 1.0;
        private TransferOptimizationParameters optimization = TransferOptimizationPreferences.DEFAULT;
        private Integer maxTransfers = 12;

        public Builder(TransferPreferences original) {
            this.original = original;
            this.cost = original.cost;
            this.slack = original.slack;
            this.maxTransfers = original.maxTransfers;
            this.waitReluctance = original.waitReluctance;
            this.optimization = original.optimization;
            this.nonpreferredCost = original.nonpreferredCost;
        }

        public TransferPreferences original() {
            return this.original;
        }

        public Builder withCost(int cost) {
            this.cost = cost;
            return this;
        }

        public Builder withSlack(int slack) {
            this.slack = slack;
            return this;
        }

        public Builder withNonpreferredCost(int nonpreferredCost) {
            this.nonpreferredCost = nonpreferredCost;
            return this;
        }

        public Builder withWaitReluctance(double waitReluctance) {
            this.waitReluctance = waitReluctance;
            return this;
        }

        public Builder withOptimization(TransferOptimizationParameters optimization) {
            this.optimization = optimization;
            return this;
        }

        public Builder withMaxTransfers(Integer maxTransfers) {
            this.maxTransfers = maxTransfers;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        TransferPreferences build() {
            TransferPreferences value = new TransferPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

