/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.framework.DurationForEnum;
import org.opentripplanner.routing.api.request.framework.Units;
import org.opentripplanner.routing.api.request.preference.ElevatorPreferences;
import org.opentripplanner.routing.core.intersection_model.DrivingDirection;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalModel;
import org.opentripplanner.util.lang.DoubleUtils;
import org.opentripplanner.util.lang.ToStringBuilder;

public final class StreetPreferences
implements Serializable {
    public static StreetPreferences DEFAULT = new StreetPreferences();
    private final double turnReluctance;
    private final DrivingDirection drivingDirection;
    private final ElevatorPreferences elevator;
    private final IntersectionTraversalModel intersectionTraversalModel;
    private final DurationForEnum<StreetMode> maxAccessEgressDuration;
    private final DurationForEnum<StreetMode> maxDirectDuration;

    private StreetPreferences() {
        this.turnReluctance = 1.0;
        this.drivingDirection = DrivingDirection.RIGHT;
        this.elevator = ElevatorPreferences.DEFAULT;
        this.intersectionTraversalModel = IntersectionTraversalModel.SIMPLE;
        this.maxAccessEgressDuration = DurationForEnum.of(StreetMode.class).withDefault(Duration.ofMinutes(45L)).build();
        this.maxDirectDuration = DurationForEnum.of(StreetMode.class).withDefault(Duration.ofHours(4L)).build();
    }

    private StreetPreferences(Builder builder) {
        this.turnReluctance = Units.reluctance(builder.turnReluctance);
        this.drivingDirection = Objects.requireNonNull(builder.drivingDirection);
        this.elevator = Objects.requireNonNull(builder.elevator);
        this.intersectionTraversalModel = Objects.requireNonNull(builder.intersectionTraversalModel);
        this.maxDirectDuration = Objects.requireNonNull(builder.maxDirectDuration);
        this.maxAccessEgressDuration = Objects.requireNonNull(builder.maxAccessEgressDuration);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public double turnReluctance() {
        return this.turnReluctance;
    }

    public DrivingDirection drivingDirection() {
        return this.drivingDirection;
    }

    public ElevatorPreferences elevator() {
        return this.elevator;
    }

    public IntersectionTraversalModel intersectionTraversalModel() {
        return this.intersectionTraversalModel;
    }

    public DurationForEnum<StreetMode> maxAccessEgressDuration() {
        return this.maxAccessEgressDuration;
    }

    public DurationForEnum<StreetMode> maxDirectDuration() {
        return this.maxDirectDuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreetPreferences that = (StreetPreferences)o;
        return DoubleUtils.doubleEquals(that.turnReluctance, this.turnReluctance) && this.drivingDirection == that.drivingDirection && this.elevator.equals(that.elevator) && this.intersectionTraversalModel == that.intersectionTraversalModel && this.maxAccessEgressDuration.equals(that.maxAccessEgressDuration) && this.maxDirectDuration.equals(that.maxDirectDuration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.turnReluctance, this.drivingDirection, this.elevator, this.intersectionTraversalModel, this.maxAccessEgressDuration, this.maxDirectDuration});
    }

    public String toString() {
        return ToStringBuilder.of(StreetPreferences.class).addNum("turnReluctance", (Number)this.turnReluctance, StreetPreferences.DEFAULT.turnReluctance).addEnum("drivingDirection", this.drivingDirection, StreetPreferences.DEFAULT.drivingDirection).addObj("elevator", this.elevator, StreetPreferences.DEFAULT.elevator).addObj("intersectionTraversalModel", (Object)this.intersectionTraversalModel, (Object)StreetPreferences.DEFAULT.intersectionTraversalModel).addObj("maxAccessEgressDuration", this.maxAccessEgressDuration, StreetPreferences.DEFAULT.maxAccessEgressDuration).addObj("maxDirectDuration", this.maxDirectDuration, StreetPreferences.DEFAULT.maxDirectDuration).toString();
    }

    public static class Builder {
        private final StreetPreferences original;
        private double turnReluctance;
        private DrivingDirection drivingDirection;
        private ElevatorPreferences elevator;
        private IntersectionTraversalModel intersectionTraversalModel;
        private DurationForEnum<StreetMode> maxAccessEgressDuration;
        private DurationForEnum<StreetMode> maxDirectDuration;

        public Builder(StreetPreferences original) {
            this.original = original;
            this.turnReluctance = original.turnReluctance;
            this.drivingDirection = original.drivingDirection;
            this.elevator = original.elevator;
            this.intersectionTraversalModel = original.intersectionTraversalModel;
            this.maxAccessEgressDuration = original.maxAccessEgressDuration;
            this.maxDirectDuration = original.maxDirectDuration;
        }

        public StreetPreferences original() {
            return this.original;
        }

        public Builder withTurnReluctance(double turnReluctance) {
            this.turnReluctance = turnReluctance;
            return this;
        }

        public Builder withDrivingDirection(DrivingDirection drivingDirection) {
            this.drivingDirection = drivingDirection;
            return this;
        }

        public Builder withElevator(Consumer<ElevatorPreferences.Builder> body) {
            this.elevator = this.elevator.copyOf().apply(body).build();
            return this;
        }

        public Builder withIntersectionTraversalModel(IntersectionTraversalModel model) {
            this.intersectionTraversalModel = model;
            return this;
        }

        public Builder withMaxAccessEgressDuration(Duration defaultValue, Map<StreetMode, Duration> values) {
            this.maxAccessEgressDuration = this.maxAccessEgressDuration.copyOf().withDefault(defaultValue).withValues(values).build();
            return this;
        }

        public Builder withMaxDirectDuration(Duration defaultValue, Map<StreetMode, Duration> valuePerMode) {
            this.maxDirectDuration = this.maxDirectDuration.copyOf().withDefault(defaultValue).withValues(valuePerMode).build();
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public StreetPreferences build() {
            StreetPreferences value = new StreetPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

