/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model;

import java.util.Collection;
import java.util.function.ToIntFunction;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.path.TransitPathLeg;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.util.time.DurationUtils;

public class MinSafeTransferTimeCalculator<T extends RaptorTripSchedule> {
    private static final double P = 6.666666666666667;
    private static final int MIN_SAFE_TRANSFER_TIME_LIMIT_UPPER_BOUND = DurationUtils.durationInSeconds("40m");
    private static final int MIN_SAFE_TRANSFER_TIME_LIMIT_LOWER_BOUND = DurationUtils.durationInSeconds("2m");
    private final RaptorSlackProvider slackProvider;

    public MinSafeTransferTimeCalculator(RaptorSlackProvider slackProvider) {
        this.slackProvider = slackProvider;
    }

    public static <T> int minSafeTransferTimeOp(Collection<T> list, ToIntFunction<T> transitTimeSeconds) {
        if (list.isEmpty()) {
            return MIN_SAFE_TRANSFER_TIME_LIMIT_UPPER_BOUND;
        }
        int minTransitTime = list.stream().mapToInt(transitTimeSeconds).min().getAsInt();
        int minSafeTransitTime = (int)Math.round((double)minTransitTime * 6.666666666666667 / 100.0);
        return MinSafeTransferTimeCalculator.bound(minSafeTransitTime, MIN_SAFE_TRANSFER_TIME_LIMIT_LOWER_BOUND, MIN_SAFE_TRANSFER_TIME_LIMIT_UPPER_BOUND);
    }

    public int minSafeTransferTime(Collection<Path<T>> paths) {
        ToIntFunction<Path> totalTransitTimeOp = p -> p.transitLegs().mapToInt(this::durationIncludingSlack).sum();
        return MinSafeTransferTimeCalculator.minSafeTransferTimeOp(paths, totalTransitTimeOp);
    }

    static int bound(int value, int lowerLimit, int upperLimit) {
        value = Math.max(value, lowerLimit);
        return Math.min(value, upperLimit);
    }

    int durationIncludingSlack(TransitPathLeg<T> leg) {
        RaptorTripPattern p = leg.trip().pattern();
        return leg.duration() + this.slackProvider.transitSlack(p.slackIndex());
    }
}

