/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripSearchTimetable;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleSearch;
import org.opentripplanner.util.lang.ToStringBuilder;

public final class TripScheduleAlightSearch<T extends RaptorTripSchedule>
implements RaptorTripScheduleSearch<T>,
RaptorTripScheduleBoardOrAlightEvent<T> {
    private final TripSearchTimetable<T> timetable;
    private final int nTrips;
    private final int binarySearchThreshold;
    private int latestAlightTime;
    private int stopPositionInPattern;
    private IntUnaryOperator arrivalTimes;
    private T candidateTrip;
    private int candidateTripIndex = -1;

    TripScheduleAlightSearch(TripSearchTimetable<T> timetable, int binarySearchThreshold) {
        this.timetable = timetable;
        this.nTrips = timetable.numberOfTripSchedules();
        this.binarySearchThreshold = binarySearchThreshold;
    }

    @Override
    public T getTrip() {
        return this.candidateTrip;
    }

    @Override
    public int getTripIndex() {
        return this.candidateTripIndex;
    }

    @Override
    public int getTime() {
        return this.candidateTrip.arrival(this.stopPositionInPattern);
    }

    @Override
    public int getStopPositionInPattern() {
        return this.stopPositionInPattern;
    }

    @Override
    public RaptorTransferConstraint getTransferConstraint() {
        return RaptorTransferConstraint.REGULAR_TRANSFER;
    }

    @Override
    public RaptorTripScheduleBoardOrAlightEvent<T> search(int latestAlightTime, int stopPositionInPattern, int tripIndexLowerBound) {
        this.latestAlightTime = latestAlightTime;
        this.stopPositionInPattern = stopPositionInPattern;
        this.arrivalTimes = this.timetable.getArrivalTimes(stopPositionInPattern);
        this.candidateTrip = null;
        this.candidateTripIndex = -1;
        if (tripIndexLowerBound == -1) {
            if (this.nTrips > this.binarySearchThreshold) {
                return this.findFirstBoardingOptimizedForLargeSetOfTrips();
            }
            return this.findBoardingSearchForwardInTime(0);
        }
        return this.findBoardingSearchForwardInTime(tripIndexLowerBound + 1);
    }

    public String toString() {
        return ToStringBuilder.of(TripScheduleAlightSearch.class).addObj("nTrips", this.nTrips).addObj("latestAlightTime", this.latestAlightTime).addObj("stopPos", this.stopPositionInPattern).addObj("tripIndex", this.candidateTripIndex).addObj("trip", this.candidateTrip).toString();
    }

    private RaptorTripScheduleBoardOrAlightEvent<T> findFirstBoardingOptimizedForLargeSetOfTrips() {
        int indexBestGuess = this.binarySearchForTripIndex();
        RaptorTripScheduleBoardOrAlightEvent<T> result = this.findBoardingSearchForwardInTime(indexBestGuess);
        if (result != null) {
            return this;
        }
        return this.findBoardingSearchBackwardsInTime(indexBestGuess);
    }

    @Nullable
    private RaptorTripScheduleBoardOrAlightEvent<T> findBoardingSearchForwardInTime(int tripIndexLowerBound) {
        int i = tripIndexLowerBound;
        while (i < this.nTrips && this.arrivalTimes.applyAsInt(i) <= this.latestAlightTime) {
            this.candidateTripIndex = i++;
        }
        if (this.candidateTripIndex == -1) {
            return null;
        }
        this.candidateTrip = this.timetable.getTripSchedule(this.candidateTripIndex);
        return this;
    }

    @Nullable
    private RaptorTripScheduleBoardOrAlightEvent<T> findBoardingSearchBackwardsInTime(int tripIndexUpperBound) {
        for (int i = tripIndexUpperBound - 1; i >= 0; --i) {
            if (this.arrivalTimes.applyAsInt(i) > this.latestAlightTime) continue;
            this.candidateTrip = this.timetable.getTripSchedule(i);
            this.candidateTripIndex = i;
            return this;
        }
        return null;
    }

    private int binarySearchForTripIndex() {
        int lower = 0;
        int upper = this.nTrips;
        while (upper - lower > this.binarySearchThreshold) {
            int m = (lower + upper) / 2;
            if (this.arrivalTimes.applyAsInt(m) <= this.latestAlightTime) {
                lower = m;
                continue;
            }
            upper = m;
        }
        return lower;
    }
}

