/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.util.time.DurationUtils;
import org.opentripplanner.util.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RaptorRoutingRequestTransitDataCreator {
    private static final Logger LOG = LoggerFactory.getLogger(RaptorRoutingRequestTransitDataCreator.class);
    private final TransitLayer transitLayer;
    private final ZonedDateTime transitSearchTimeZero;
    private final LocalDate departureDate;

    RaptorRoutingRequestTransitDataCreator(TransitLayer transitLayer, ZonedDateTime transitSearchTimeZero) {
        this.transitLayer = transitLayer;
        this.departureDate = transitSearchTimeZero.toLocalDate();
        this.transitSearchTimeZero = transitSearchTimeZero;
    }

    public List<int[]> createTripPatternsPerStop(List<TripPatternForDates> tripPatternsForDate) {
        int stopCount = this.transitLayer.getStopCount();
        TIntArrayList[] patternsForStop = new TIntArrayList[stopCount];
        for (int i = 0; i < stopCount; ++i) {
            patternsForStop[i] = new TIntArrayList();
        }
        for (TripPatternForDates tripPatternForDateList : tripPatternsForDate) {
            RoutingTripPattern tripPattern = tripPatternForDateList.getTripPattern();
            int patternIndex = tripPattern.patternIndex();
            int numberOfStopsInPattern = tripPattern.numberOfStopsInPattern();
            for (int i = 0; i < numberOfStopsInPattern; ++i) {
                patternsForStop[tripPattern.stopIndex(i)].add(patternIndex);
            }
        }
        ArrayList<int[]> result = new ArrayList<int[]>();
        for (TIntArrayList patterns : patternsForStop) {
            result.add(patterns.toArray());
        }
        return result;
    }

    public List<TripPatternForDates> createPatternIndex(List<TripPatternForDates> tripPatterns) {
        TripPatternForDates[] result = new TripPatternForDates[RoutingTripPattern.indexCounter()];
        Iterator<TripPatternForDates> iterator = tripPatterns.iterator();
        while (iterator.hasNext()) {
            TripPatternForDates pattern;
            result[pattern.getTripPattern().patternIndex()] = pattern = iterator.next();
        }
        return Arrays.asList(result);
    }

    static List<TripPatternForDates> merge(ZonedDateTime transitSearchTimeZero, List<TripPatternForDate> patternForDateList, TransitDataProviderFilter filter) {
        HashMap<RoutingTripPattern, List> patternForDateByPattern = new HashMap<RoutingTripPattern, List>();
        for (TripPatternForDate patternForDate : patternForDateList) {
            patternForDateByPattern.computeIfAbsent(patternForDate.getTripPattern(), k -> new ArrayList()).add(patternForDate);
        }
        ArrayList<TripPatternForDates> combinedList = new ArrayList<TripPatternForDates>();
        TObjectIntHashMap offsetCache = new TObjectIntHashMap();
        for (Map.Entry patternEntry : patternForDateByPattern.entrySet()) {
            List patternsSorted = (List)patternEntry.getValue();
            patternsSorted.sort(Comparator.comparing(TripPatternForDate::getLocalDate));
            TIntArrayList offsets = new TIntArrayList();
            for (TripPatternForDate tripPatternForDate : patternsSorted) {
                int offset;
                LocalDate serviceDate = tripPatternForDate.getLocalDate();
                if (offsetCache.containsKey((Object)serviceDate)) {
                    offset = offsetCache.get((Object)serviceDate);
                } else {
                    offset = ServiceDateUtils.secondsSinceStartOfTime(transitSearchTimeZero, serviceDate);
                    offsetCache.put((Object)serviceDate, offset);
                }
                offsets.add(offset);
            }
            RoutingTripPattern tripPattern = (RoutingTripPattern)patternEntry.getKey();
            combinedList.add(new TripPatternForDates(tripPattern, patternsSorted, (TIntList)offsets, filter.filterAvailableStops(tripPattern, tripPattern.getBoardingPossible()), filter.filterAvailableStops(tripPattern, tripPattern.getAlightingPossible())));
        }
        return combinedList;
    }

    List<TripPatternForDates> createTripPatterns(int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter) {
        List<TripPatternForDate> tripPatternForDates = this.getTripPatternsForDateRange(additionalPastSearchDays, additionalFutureSearchDays, filter);
        return RaptorRoutingRequestTransitDataCreator.merge(this.transitSearchTimeZero, tripPatternForDates, filter);
    }

    private static List<TripPatternForDate> filterActiveTripPatterns(TransitLayer transitLayer, LocalDate date, boolean firstDay, TransitDataProviderFilter filter) {
        return transitLayer.getTripPatternsForDate(date).stream().filter(filter::tripPatternPredicate).filter(p -> firstDay || p.getStartOfRunningPeriod().toLocalDate().equals(date)).map(p -> p.newWithFilteredTripTimes(filter::tripTimesPredicate)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<TripPatternForDate> getTripPatternsForDateRange(int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter) {
        ArrayList<TripPatternForDate> tripPatternForDates = new ArrayList<TripPatternForDate>();
        long start = System.currentTimeMillis();
        for (int d = -additionalPastSearchDays; d <= additionalFutureSearchDays; ++d) {
            tripPatternForDates.addAll(RaptorRoutingRequestTransitDataCreator.filterActiveTripPatterns(this.transitLayer, this.departureDate.plusDays(d), d == 0, filter));
        }
        if (LOG.isDebugEnabled()) {
            String time = DurationUtils.msToSecondsStr(System.currentTimeMillis() - start);
            long count = tripPatternForDates.size();
            LOG.debug("Prepare Transit model performed in {}, count: {}.", (Object)time, (Object)count);
        }
        return tripPatternForDates;
    }
}

