/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPatternByStopPos;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.CostCalculatorFactory;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.GeneralizedCostParametersMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitDataCreator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTripScheduleBoardingSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorRoute;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.transit.raptor.util.BitSetIterator;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.time.ServiceDateUtils;

public class RaptorRoutingRequestTransitData
implements RaptorTransitDataProvider<TripSchedule> {
    private final TransitLayer transitLayer;
    private final TransferService transferService;
    private final List<int[]> activeTripPatternsPerStop;
    private final List<TripPatternForDates> patternIndex;
    private final RaptorTransferIndex transferIndex;
    private final List<TransferForPatternByStopPos> forwardConstrainedTransfers;
    private final List<TransferForPatternByStopPos> reverseConstrainedTransfers;
    private final ZonedDateTime transitSearchTimeZero;
    private final CostCalculator<TripSchedule> generalizedCostCalculator;
    private final int validTransitDataStartTime;
    private final int validTransitDataEndTime;

    public RaptorRoutingRequestTransitData(TransitLayer transitLayer, ZonedDateTime transitSearchTimeZero, int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter, RouteRequest request) {
        this.transferService = transitLayer.getTransferService();
        this.transitLayer = transitLayer;
        this.transitSearchTimeZero = transitSearchTimeZero;
        RaptorRoutingRequestTransitDataCreator transitDataCreator = new RaptorRoutingRequestTransitDataCreator(transitLayer, transitSearchTimeZero);
        List<TripPatternForDates> tripPatterns = transitDataCreator.createTripPatterns(additionalPastSearchDays, additionalFutureSearchDays, filter);
        this.patternIndex = transitDataCreator.createPatternIndex(tripPatterns);
        this.activeTripPatternsPerStop = transitDataCreator.createTripPatternsPerStop(tripPatterns);
        this.transferIndex = transitLayer.getRaptorTransfersForRequest(request);
        this.forwardConstrainedTransfers = transitLayer.getForwardConstrainedTransfers();
        this.reverseConstrainedTransfers = transitLayer.getReverseConstrainedTransfers();
        GeneralizedCostParameters mcCostParams = GeneralizedCostParametersMapper.map(request, this.patternIndex);
        this.generalizedCostCalculator = CostCalculatorFactory.createCostCalculator(mcCostParams, transitLayer.getStopBoardAlightCosts());
        this.validTransitDataStartTime = ServiceDateUtils.secondsSinceStartOfTime(this.transitSearchTimeZero, this.transitSearchTimeZero.minusDays(additionalPastSearchDays).toInstant());
        this.validTransitDataEndTime = ServiceDateUtils.secondsSinceStartOfTime(this.transitSearchTimeZero, this.transitSearchTimeZero.plusDays(additionalFutureSearchDays + 1).toInstant());
    }

    @Override
    public Iterator<RaptorTransfer> getTransfersFromStop(int stopIndex) {
        return this.transferIndex.getForwardTransfers(stopIndex).iterator();
    }

    @Override
    public Iterator<? extends RaptorTransfer> getTransfersToStop(int stopIndex) {
        return this.transferIndex.getReversedTransfers(stopIndex).iterator();
    }

    @Override
    public IntIterator routeIndexIterator(IntIterator stops) {
        BitSet activeTripPatternsForGivenStops = new BitSet(RoutingTripPattern.indexCounter());
        while (stops.hasNext()) {
            int[] patterns;
            for (int i : patterns = this.activeTripPatternsPerStop.get(stops.next())) {
                activeTripPatternsForGivenStops.set(i);
            }
        }
        return new BitSetIterator(activeTripPatternsForGivenStops);
    }

    @Override
    public RaptorRoute<TripSchedule> getRouteForIndex(int routeIndex) {
        return this.patternIndex.get(routeIndex);
    }

    @Override
    public int numberOfStops() {
        return this.transitLayer.getStopCount();
    }

    @Override
    public CostCalculator<TripSchedule> multiCriteriaCostCalculator() {
        return this.generalizedCostCalculator;
    }

    @Override
    public RaptorPathConstrainedTransferSearch<TripSchedule> transferConstraintsSearch() {
        if (OTPFeature.TransferConstraints.isOff() || this.transferService == null) {
            return null;
        }
        return new RaptorPathConstrainedTransferSearch<TripSchedule>(){

            @Override
            @Nullable
            public RaptorConstrainedTransfer findConstrainedTransfer(TripSchedule fromTrip, int fromStopPosition, TripSchedule toTrip, int toStopPosition) {
                return RaptorRoutingRequestTransitData.this.transferService.findTransfer(fromTrip.getOriginalTripTimes().getTrip(), fromStopPosition, RaptorRoutingRequestTransitData.this.transitLayer.getStopByIndex(fromTrip.pattern().stopIndex(fromStopPosition)), toTrip.getOriginalTripTimes().getTrip(), toStopPosition, RaptorRoutingRequestTransitData.this.transitLayer.getStopByIndex(toTrip.pattern().stopIndex(toStopPosition)));
            }
        };
    }

    @Override
    @Nonnull
    public RaptorStopNameResolver stopNameResolver() {
        return stopIndex -> {
            StopLocation s = this.transitLayer.getStopByIndex(stopIndex);
            return s == null ? "null" : s.getName() + "(" + stopIndex + ")";
        };
    }

    @Override
    public int getValidTransitDataStartTime() {
        return this.validTransitDataStartTime;
    }

    @Override
    public int getValidTransitDataEndTime() {
        return this.validTransitDataEndTime;
    }

    @Override
    public RaptorConstrainedTripScheduleBoardingSearch<TripSchedule> transferConstraintsForwardSearch(int routeIndex) {
        TransferForPatternByStopPos transfers = this.forwardConstrainedTransfers.get(routeIndex);
        if (transfers == null) {
            return ConstrainedBoardingSearch.NOOP_SEARCH;
        }
        return new ConstrainedBoardingSearch(true, transfers);
    }

    @Override
    public RaptorConstrainedTripScheduleBoardingSearch<TripSchedule> transferConstraintsReverseSearch(int routeIndex) {
        TransferForPatternByStopPos transfers = this.reverseConstrainedTransfers.get(routeIndex);
        if (transfers == null) {
            return ConstrainedBoardingSearch.NOOP_SEARCH;
        }
        return new ConstrainedBoardingSearch(false, transfers);
    }
}

