/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.preference.TimeSlopeSafetyTriangle;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.routing.core.BicycleOptimizeType;

public class RaptorRequestTransferCache {
    private final LoadingCache<CacheKey, RaptorTransferIndex> transferCache;

    public RaptorRequestTransferCache(int maximumSize) {
        this.transferCache = CacheBuilder.newBuilder().maximumSize((long)maximumSize).build(this.cacheLoader());
    }

    public LoadingCache<CacheKey, RaptorTransferIndex> getTransferCache() {
        return this.transferCache;
    }

    public RaptorTransferIndex get(List<List<Transfer>> transfersByStopIndex, RouteRequest request) {
        try {
            return (RaptorTransferIndex)this.transferCache.get((Object)new CacheKey(transfersByStopIndex, request));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to get item from transfer cache", e);
        }
    }

    private CacheLoader<CacheKey, RaptorTransferIndex> cacheLoader() {
        return new CacheLoader<CacheKey, RaptorTransferIndex>(){

            public RaptorTransferIndex load(@Nonnull CacheKey cacheKey) {
                return RaptorTransferIndex.create(cacheKey.transfersByStopIndex, cacheKey.request);
            }
        };
    }

    private static class CacheKey {
        private final List<List<Transfer>> transfersByStopIndex;
        private final RouteRequest request;
        private final StreetRelevantOptions options;

        private CacheKey(List<List<Transfer>> transfersByStopIndex, RouteRequest request) {
            this.transfersByStopIndex = transfersByStopIndex;
            this.request = request;
            this.options = new StreetRelevantOptions(request);
        }

        public int hashCode() {
            return this.options.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.transfersByStopIndex == cacheKey.transfersByStopIndex && this.options.equals(cacheKey.options);
        }
    }

    private static class StreetRelevantOptions {
        private final StreetMode transferMode;
        private final BicycleOptimizeType optimize;
        private final TimeSlopeSafetyTriangle bikeOptimizeTimeSlopeSafety;
        private final boolean wheelchair;
        private final WheelchairPreferences wheelchairPreferences;
        private final double walkSpeed;
        private final double bikeSpeed;
        private final double walkReluctance;
        private final double stairsReluctance;
        private final double stairsTimeFactor;
        private final double turnReluctance;
        private final int elevatorBoardCost;
        private final int elevatorBoardTime;
        private final int elevatorHopCost;
        private final int elevatorHopTime;
        private final int bikeSwitchCost;
        private final int bikeSwitchTime;

        public StreetRelevantOptions(RouteRequest routingRequest) {
            RoutingPreferences preferences = routingRequest.preferences();
            this.transferMode = routingRequest.journey().transfer().mode();
            this.optimize = preferences.bike().optimizeType();
            this.bikeOptimizeTimeSlopeSafety = preferences.bike().optimizeTriangle();
            this.bikeSwitchCost = preferences.bike().switchCost();
            this.bikeSwitchTime = preferences.bike().switchTime();
            this.wheelchair = routingRequest.wheelchair();
            this.wheelchairPreferences = preferences.wheelchair();
            this.walkSpeed = preferences.walk().speed();
            this.bikeSpeed = preferences.bike().speed();
            this.walkReluctance = preferences.walk().reluctance();
            this.stairsReluctance = preferences.walk().stairsReluctance();
            this.stairsTimeFactor = preferences.walk().stairsTimeFactor();
            this.turnReluctance = preferences.street().turnReluctance();
            this.elevatorBoardCost = preferences.street().elevator().boardCost();
            this.elevatorBoardTime = preferences.street().elevator().boardTime();
            this.elevatorHopCost = preferences.street().elevator().hopCost();
            this.elevatorHopTime = preferences.street().elevator().hopTime();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.transferMode, this.optimize, this.bikeOptimizeTimeSlopeSafety, this.wheelchair, this.wheelchairPreferences, this.walkSpeed, this.bikeSpeed, this.walkReluctance, this.stairsReluctance, this.turnReluctance, this.elevatorBoardCost, this.elevatorBoardTime, this.elevatorHopCost, this.elevatorHopTime, this.bikeSwitchCost, this.bikeSwitchTime, this.stairsTimeFactor});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreetRelevantOptions that = (StreetRelevantOptions)o;
            return Double.compare(that.walkSpeed, this.walkSpeed) == 0 && Double.compare(that.bikeSpeed, this.bikeSpeed) == 0 && Double.compare(that.walkReluctance, this.walkReluctance) == 0 && Double.compare(that.stairsReluctance, this.stairsReluctance) == 0 && Double.compare(that.stairsTimeFactor, this.stairsTimeFactor) == 0 && Double.compare(that.turnReluctance, this.turnReluctance) == 0 && Objects.equals(that.bikeOptimizeTimeSlopeSafety, this.bikeOptimizeTimeSlopeSafety) && this.wheelchair == that.wheelchair && this.wheelchairPreferences.equals(that.wheelchairPreferences) && this.elevatorBoardCost == that.elevatorBoardCost && this.elevatorBoardTime == that.elevatorBoardTime && this.elevatorHopCost == that.elevatorHopCost && this.elevatorHopTime == that.elevatorHopTime && this.bikeSwitchCost == that.bikeSwitchCost && this.bikeSwitchTime == that.bikeSwitchTime && this.transferMode == that.transferMode && this.optimize == that.optimize;
        }
    }
}

