/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import com.google.common.collect.ArrayListMultimap;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedTransfersForPatterns;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferIndexGenerator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransfersMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TripPatternForDateMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRequestTransferCache;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopTransferPriority;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.StopModel;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitLayerMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TransitLayerMapper.class);
    private final TransitModel transitModel;

    private TransitLayerMapper(TransitModel transitModel) {
        this.transitModel = transitModel;
    }

    public static TransitLayer map(TransitTuningParameters tuningParameters, TransitModel transitModel) {
        return new TransitLayerMapper(transitModel).map(tuningParameters);
    }

    static List<TripTimes> getSortedTripTimes(Timetable timetable) {
        return timetable.getTripTimes().stream().sorted(Comparator.comparing(TripTimes::sortIndex)).collect(Collectors.toList());
    }

    private TransitLayer map(TransitTuningParameters tuningParameters) {
        ConstrainedTransfersForPatterns constrainedTransfers = null;
        StopModel stopModel = this.transitModel.getStopModel();
        LOG.info("Mapping transitLayer from Graph...");
        Collection<TripPattern> allTripPatterns = this.transitModel.getAllTripPatterns();
        HashMap<LocalDate, List<TripPatternForDate>> tripPatternsByStopByDate = this.mapTripPatterns(allTripPatterns);
        List<List<Transfer>> transferByStopIndex = TransfersMapper.mapTransfers(stopModel, this.transitModel);
        TransferIndexGenerator transferIndexGenerator = null;
        if (OTPFeature.TransferConstraints.isOn()) {
            transferIndexGenerator = new TransferIndexGenerator(this.transitModel.getTransferService().listAll(), allTripPatterns);
            constrainedTransfers = transferIndexGenerator.generateTransfers();
        }
        RaptorRequestTransferCache transferCache = new RaptorRequestTransferCache(tuningParameters.transferCacheMaxSize());
        LOG.info("Mapping complete.");
        return new TransitLayer(tripPatternsByStopByDate, transferByStopIndex, this.transitModel.getTransferService(), stopModel, this.transitModel.getTimeZone(), transferCache, constrainedTransfers, transferIndexGenerator, TransitLayerMapper.createStopTransferCosts(stopModel, tuningParameters));
    }

    private HashMap<LocalDate, List<TripPatternForDate>> mapTripPatterns(Collection<TripPattern> allTripPatterns) {
        TripPatternForDateMapper tripPatternForDateMapper = new TripPatternForDateMapper(this.transitModel.getTransitModelIndex().getServiceCodesRunningForDate());
        Set<LocalDate> allServiceDates = this.transitModel.getTransitModelIndex().getServiceCodesRunningForDate().keySet();
        List<TripPatternForDate> tripPatternForDates = Collections.synchronizedList(new ArrayList());
        allServiceDates.parallelStream().forEach(serviceDate -> {
            ArrayList<TripPatternForDate> values = new ArrayList<TripPatternForDate>();
            for (TripPattern oldTripPattern : allTripPatterns) {
                TripPatternForDate tripPatternForDate = tripPatternForDateMapper.map(oldTripPattern.getScheduledTimetable(), (LocalDate)serviceDate);
                if (tripPatternForDate == null) continue;
                values.add(tripPatternForDate);
            }
            if (!values.isEmpty()) {
                tripPatternForDates.addAll(values);
            }
        });
        return this.keyByRunningPeriodDates(tripPatternForDates);
    }

    private HashMap<LocalDate, List<TripPatternForDate>> keyByRunningPeriodDates(List<TripPatternForDate> tripPatternForDates) {
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        for (TripPatternForDate tripPatternForDate : tripPatternForDates) {
            for (LocalDate date : tripPatternForDate.getRunningPeriodDates()) {
                multiMap.put((Object)date, (Object)tripPatternForDate);
            }
        }
        HashMap<LocalDate, List<TripPatternForDate>> result = new HashMap<LocalDate, List<TripPatternForDate>>();
        for (Map.Entry entry : multiMap.asMap().entrySet()) {
            result.put((LocalDate)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return result;
    }

    static int[] createStopTransferCosts(StopModel stops, TransitTuningParameters tuningParams) {
        if (!tuningParams.enableStopTransferPriority()) {
            return null;
        }
        int[] stopTransferCosts = new int[stops.stopIndexSize()];
        for (int i = 0; i < stops.stopIndexSize(); ++i) {
            StopTransferPriority priority = stops.stopByIndex(i).getPriority();
            int domainCost = tuningParams.stopTransferCost(priority);
            stopTransferCosts[i] = RaptorCostConverter.toRaptorCost(domainCost);
        }
        return stopTransferCosts;
    }
}

