/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import org.opentripplanner.util.lang.OtpNumberFormat;

public final class RaptorCostConverter {
    private static final int NOT_SET = -1;
    private static final int PRECISION = 100;
    private static final int HALF = 50;

    private RaptorCostConverter() {
    }

    public static int toOtpDomainCost(int raptorCost) {
        if (raptorCost == -1) {
            return -1;
        }
        return (raptorCost + 50) / 100;
    }

    public static String toString(int raptorCost) {
        return OtpNumberFormat.formatCostCenti(raptorCost);
    }

    public static int toRaptorCost(double domainCost) {
        return (int)(domainCost * 100.0 + 0.5);
    }

    public static int toRaptorCost(int domainCost) {
        return domainCost * 100;
    }

    public static int[] toRaptorCosts(double[] domainValues) {
        int[] raptorCost = new int[domainValues.length];
        for (int i = 0; i < domainValues.length; ++i) {
            raptorCost[i] = RaptorCostConverter.toRaptorCost(domainValues[i]);
        }
        return raptorCost;
    }
}

