/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import java.util.BitSet;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParameters;
import org.opentripplanner.routing.api.request.framework.DoubleAlgorithmFunction;
import org.opentripplanner.routing.api.request.preference.AccessibilityPreferences;

public class GeneralizedCostParametersBuilder {
    private int boardCost;
    private int transferCost;
    private double[] transitReluctanceFactors;
    private double waitReluctanceFactor;
    private boolean wheelchairEnabled;
    private AccessibilityPreferences wheelchairAccessibility;
    private BitSet unpreferredPatterns;
    private DoubleAlgorithmFunction unpreferredCost;

    public GeneralizedCostParametersBuilder() {
        this(GeneralizedCostParameters.DEFAULTS);
    }

    private GeneralizedCostParametersBuilder(GeneralizedCostParameters other) {
        this.boardCost = other.boardCost();
        this.transferCost = other.transferCost();
        this.transitReluctanceFactors = other.transitReluctanceFactors();
        this.waitReluctanceFactor = other.waitReluctanceFactor();
        this.wheelchairEnabled = other.wheelchairEnabled();
        this.wheelchairAccessibility = other.wheelchairAccessibility();
        this.unpreferredPatterns = other.unpreferredPatterns();
    }

    public int boardCost() {
        return this.boardCost;
    }

    public GeneralizedCostParametersBuilder boardCost(int boardCost) {
        this.boardCost = boardCost;
        return this;
    }

    public int transferCost() {
        return this.transferCost;
    }

    public GeneralizedCostParametersBuilder transferCost(int transferCost) {
        this.transferCost = transferCost;
        return this;
    }

    public double[] transitReluctanceFactors() {
        return this.transitReluctanceFactors;
    }

    public GeneralizedCostParametersBuilder transitReluctanceFactors(double[] transitReluctanceFactors) {
        this.transitReluctanceFactors = transitReluctanceFactors;
        return this;
    }

    public double waitReluctanceFactor() {
        return this.waitReluctanceFactor;
    }

    public GeneralizedCostParametersBuilder waitReluctanceFactor(double waitReluctanceFactor) {
        this.waitReluctanceFactor = waitReluctanceFactor;
        return this;
    }

    public boolean wheelchairEnabled() {
        return this.wheelchairEnabled;
    }

    public AccessibilityPreferences wheelchairAccessibility() {
        return this.wheelchairAccessibility;
    }

    public GeneralizedCostParametersBuilder wheelchairEnabled(boolean wheelchairEnabled) {
        this.wheelchairEnabled = wheelchairEnabled;
        return this;
    }

    public GeneralizedCostParametersBuilder wheelchairAccessibility(AccessibilityPreferences wheelchairAccessibility) {
        this.wheelchairAccessibility = wheelchairAccessibility;
        return this;
    }

    public BitSet unpreferredPatterns() {
        return this.unpreferredPatterns;
    }

    public GeneralizedCostParametersBuilder unpreferredPatterns(BitSet patterns) {
        this.unpreferredPatterns = patterns;
        return this;
    }

    public DoubleAlgorithmFunction unpreferredCost() {
        return this.unpreferredCost;
    }

    public GeneralizedCostParametersBuilder unpreferredCost(DoubleAlgorithmFunction unpreferredCost) {
        this.unpreferredCost = unpreferredCost;
        return this;
    }

    public GeneralizedCostParameters build() {
        return new GeneralizedCostParameters(this);
    }
}

