/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.PatternCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.WheelchairCostCalculator;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;

public class CostCalculatorFactory {
    public static <T extends DefaultTripSchedule> CostCalculator<T> createCostCalculator(GeneralizedCostParameters generalizedCostParameters, int[] stopBoardAlightCosts) {
        CostCalculator calculator = new DefaultCostCalculator(generalizedCostParameters, stopBoardAlightCosts);
        if (generalizedCostParameters.wheelchairEnabled()) {
            calculator = new WheelchairCostCalculator(calculator, generalizedCostParameters.wheelchairAccessibility());
        }
        if (!generalizedCostParameters.unpreferredPatterns().isEmpty()) {
            calculator = new PatternCostCalculator(calculator, generalizedCostParameters.unpreferredPatterns(), generalizedCostParameters.unnpreferredCost());
        }
        return calculator;
    }
}

