/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.RouteStationTransferPoint;
import org.opentripplanner.model.transfer.RouteStopTransferPoint;
import org.opentripplanner.model.transfer.StationTransferPoint;
import org.opentripplanner.model.transfer.StopTransferPoint;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedTransfersForPatterns;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPattern;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPatternByStopPos;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferPointForPatternFactory;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferPointMatcher;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;

public class TransferIndexGenerator {
    private static final boolean BOARD = true;
    private static final boolean ALIGHT = false;
    private final Collection<ConstrainedTransfer> constrainedTransfers;
    private final Map<Station, Set<RoutingTripPattern>> patternsByStation = new HashMap<Station, Set<RoutingTripPattern>>();
    private final Map<StopLocation, Set<RoutingTripPattern>> patternsByStop = new HashMap<StopLocation, Set<RoutingTripPattern>>();
    private final Map<Route, Set<RoutingTripPattern>> patternsByRoute = new HashMap<Route, Set<RoutingTripPattern>>();
    private final Map<Trip, Set<RoutingTripPattern>> patternsByTrip = new HashMap<Trip, Set<RoutingTripPattern>>();

    public TransferIndexGenerator(Collection<ConstrainedTransfer> constrainedTransfers, Collection<TripPattern> tripPatterns) {
        this.constrainedTransfers = constrainedTransfers;
        this.setupPatterns(tripPatterns);
    }

    public ConstrainedTransfersForPatterns generateTransfers() {
        int nPatterns = RoutingTripPattern.indexCounter();
        TransferForPatternByStopPos[] forwardTransfers = new TransferForPatternByStopPos[nPatterns];
        TransferForPatternByStopPos[] reverseTransfers = new TransferForPatternByStopPos[nPatterns];
        for (ConstrainedTransfer tx : this.constrainedTransfers) {
            TransferConstraint c = tx.getTransferConstraint();
            if (!c.includeInRaptorRouting()) continue;
            this.findTPoints(tx.getFrom(), false).stream().filter(TPoint::canAlight).forEachOrdered(fromPoint -> {
                for (TPoint toPoint : this.findTPoints(tx.getTo(), true)) {
                    if (!toPoint.canBoard() || fromPoint.equals(toPoint)) continue;
                    fromPoint.addTransferConstraints(tx, toPoint, forwardTransfers, reverseTransfers);
                }
            });
        }
        this.sortTransfers(forwardTransfers);
        this.sortTransfers(reverseTransfers);
        return new ConstrainedTransfersForPatterns(Arrays.asList(forwardTransfers), Arrays.asList(reverseTransfers));
    }

    public void addRealtimeTrip(TripPattern tripPattern, List<Trip> trips) {
        this.setupPattern(tripPattern, trips);
    }

    private void setupPatterns(Collection<TripPattern> tripPatterns) {
        for (TripPattern tripPattern : tripPatterns) {
            this.setupPattern(tripPattern, tripPattern.scheduledTripsAsStream().toList());
        }
    }

    private void setupPattern(TripPattern tripPattern, List<Trip> trips) {
        RoutingTripPattern pattern = tripPattern.getRoutingTripPattern();
        this.patternsByRoute.computeIfAbsent(tripPattern.getRoute(), t -> new HashSet()).add(pattern);
        for (Trip trip : trips) {
            this.patternsByTrip.computeIfAbsent(trip, t -> new HashSet()).add(pattern);
        }
        for (StopLocation stop : tripPattern.getStops()) {
            this.patternsByStop.computeIfAbsent(stop, t -> new HashSet()).add(pattern);
            Station station = stop.getParentStation();
            if (station == null) continue;
            this.patternsByStation.computeIfAbsent(station, t -> new HashSet()).add(pattern);
        }
    }

    private void sortTransfers(TransferForPatternByStopPos[] transfers) {
        for (TransferForPatternByStopPos transfersForStop : transfers) {
            if (transfersForStop == null) continue;
            transfersForStop.sortOnSpecificityRanking();
        }
    }

    private Collection<TPoint> findTPoints(TransferPoint txPoint, boolean boarding) {
        if (txPoint.isStationTransferPoint()) {
            return this.findTPoints(txPoint.asStationTransferPoint());
        }
        if (txPoint.isStopTransferPoint()) {
            return this.findTPoints(txPoint.asStopTransferPoint());
        }
        if (txPoint.isRouteStationTransferPoint()) {
            return this.findTPoint(txPoint.asRouteStationTransferPoint(), boarding);
        }
        if (txPoint.isRouteStopTransferPoint()) {
            return this.findTPoint(txPoint.asRouteStopTransferPoint(), boarding);
        }
        return this.findTPoints(txPoint.asTripTransferPoint());
    }

    private List<TPoint> findTPoints(StationTransferPoint point) {
        Station station = point.getStation();
        Set<RoutingTripPattern> patterns = this.patternsByStation.get(station);
        if (patterns == null) {
            return List.of();
        }
        TransferPointMatcher sourcePoint = TransferPointForPatternFactory.createTransferPointForPattern(station);
        ArrayList<TPoint> result = new ArrayList<TPoint>();
        for (RoutingTripPattern pattern : patterns) {
            TripPattern tripPattern = pattern.getPattern();
            for (int pos = 0; pos < tripPattern.numberOfStops(); ++pos) {
                if (point.getStation() != tripPattern.getStop(pos).getParentStation()) continue;
                result.add(new TPoint(pattern, sourcePoint, null, pos));
            }
        }
        return result;
    }

    private List<TPoint> findTPoints(StopTransferPoint point) {
        StopLocation stop = point.asStopTransferPoint().getStop();
        Set<RoutingTripPattern> patterns = this.patternsByStop.get(stop);
        if (patterns == null) {
            return List.of();
        }
        TransferPointMatcher sourcePoint = TransferPointForPatternFactory.createTransferPointForPattern(stop.getIndex());
        ArrayList<TPoint> result = new ArrayList<TPoint>();
        for (RoutingTripPattern pattern : patterns) {
            TripPattern p = pattern.getPattern();
            for (int pos = 0; pos < p.numberOfStops(); ++pos) {
                if (point.getStop() != p.getStop(pos)) continue;
                result.add(new TPoint(pattern, sourcePoint, null, pos));
            }
        }
        return result;
    }

    private List<TPoint> findTPoint(RouteStationTransferPoint point, boolean boarding) {
        return this.findTPointForRoute(point.getRoute(), boarding ? p -> p.findBoardingStopPositionInPattern(point.getStation()) : p -> p.findAlightStopPositionInPattern(point.getStation()));
    }

    private List<TPoint> findTPoint(RouteStopTransferPoint point, boolean boarding) {
        return this.findTPointForRoute(point.getRoute(), boarding ? p -> p.findBoardingStopPositionInPattern(point.getStop()) : p -> p.findAlightStopPositionInPattern(point.getStop()));
    }

    private List<TPoint> findTPointForRoute(Route route, ToIntFunction<TripPattern> resolveStopPosInPattern) {
        Set<RoutingTripPattern> patterns = this.patternsByRoute.get(route);
        if (patterns == null) {
            return List.of();
        }
        ArrayList<TPoint> points = new ArrayList<TPoint>();
        for (RoutingTripPattern pattern : patterns) {
            int stopPosInPattern = resolveStopPosInPattern.applyAsInt(pattern.getPattern());
            if (stopPosInPattern < 0) continue;
            int stopIndex = pattern.stopIndex(stopPosInPattern);
            TransferPointMatcher sourcePoint = TransferPointForPatternFactory.createTransferPointForPattern(route, stopIndex);
            points.add(new TPoint(pattern, sourcePoint, null, stopPosInPattern));
        }
        return points;
    }

    private List<TPoint> findTPoints(TripTransferPoint point) {
        Trip trip = point.getTrip();
        Set<RoutingTripPattern> patterns = this.patternsByTrip.get(trip);
        int stopPosInPattern = point.getStopPositionInPattern();
        int stopIndex = patterns.iterator().next().stopIndex(stopPosInPattern);
        TransferPointMatcher sourcePoint = TransferPointForPatternFactory.createTransferPointForPattern(trip, stopIndex);
        return patterns.stream().map(p -> new TPoint((RoutingTripPattern)p, sourcePoint, trip, stopPosInPattern)).collect(Collectors.toList());
    }

    private static class TPoint {
        RoutingTripPattern pattern;
        TransferPointMatcher sourcePoint;
        Trip trip;
        int stopPosition;

        private TPoint(RoutingTripPattern pattern, TransferPointMatcher sourcePoint, Trip trip, int stopPosition) {
            this.pattern = pattern;
            this.sourcePoint = sourcePoint;
            this.trip = trip;
            this.stopPosition = stopPosition;
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.trip, this.stopPosition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TPoint)) {
                return false;
            }
            TPoint tPoint = (TPoint)o;
            return this.stopPosition == tPoint.stopPosition && Objects.equals(this.pattern, tPoint.pattern) && Objects.equals(this.trip, tPoint.trip);
        }

        boolean canBoard() {
            int lastStopPosition = this.pattern.numberOfStopsInPattern() - 1;
            return this.stopPosition != lastStopPosition && this.pattern.boardingPossibleAt(this.stopPosition);
        }

        boolean canAlight() {
            return this.stopPosition != 0 && this.pattern.alightingPossibleAt(this.stopPosition);
        }

        void addTransferConstraints(ConstrainedTransfer tx, TPoint to, TransferForPatternByStopPos[] forwardTransfers, TransferForPatternByStopPos[] reverseTransfers) {
            int rank = tx.getSpecificityRanking();
            TransferConstraint c = tx.getTransferConstraint();
            if (forwardTransfers[to.pattern.patternIndex()] == null) {
                forwardTransfers[to.pattern.patternIndex()] = new TransferForPatternByStopPos();
            }
            forwardTransfers[to.pattern.patternIndex()].add(to.stopPosition, new TransferForPattern(this.sourcePoint, to.trip, rank, c));
            if (reverseTransfers[this.pattern.patternIndex()] == null) {
                reverseTransfers[this.pattern.patternIndex()] = new TransferForPatternByStopPos();
            }
            reverseTransfers[this.pattern.patternIndex()].add(this.stopPosition, new TransferForPattern(to.sourcePoint, this.trip, rank, c));
        }
    }
}

