/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultRaptorTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.api.request.preference.WalkPreferences;
import org.opentripplanner.routing.core.AStarRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;

public class Transfer {
    private final int toStop;
    private final int distanceMeters;
    private final List<Edge> edges;

    public Transfer(int toStop, List<Edge> edges) {
        this.toStop = toStop;
        this.edges = edges;
        this.distanceMeters = (int)edges.stream().mapToDouble(Edge::getDistanceMeters).sum();
    }

    public Transfer(int toStopIndex, int distanceMeters) {
        this.toStop = toStopIndex;
        this.distanceMeters = distanceMeters;
        this.edges = null;
    }

    public List<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        if (this.edges == null) {
            return coordinates;
        }
        for (Edge edge : this.edges) {
            if (edge.getGeometry() == null) continue;
            coordinates.addAll(Arrays.asList(edge.getGeometry().getCoordinates()));
        }
        return coordinates;
    }

    public int getToStop() {
        return this.toStop;
    }

    public int getDistanceMeters() {
        return this.distanceMeters;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Optional<RaptorTransfer> asRaptorTransfer(AStarRequest request) {
        WalkPreferences walkPreferences = request.preferences().walk();
        if (this.edges == null || this.edges.isEmpty()) {
            double durationSeconds = (double)this.distanceMeters / walkPreferences.speed();
            return Optional.of(new DefaultRaptorTransfer(this.toStop, (int)Math.ceil(durationSeconds), RaptorCostConverter.toRaptorCost(durationSeconds * walkPreferences.reluctance()), this));
        }
        StateEditor se = new StateEditor(this.edges.get(0).getFromVertex(), request);
        se.setTimeSeconds(0L);
        State s = se.makeState();
        for (Edge e : this.edges) {
            s = e.traverse(s);
            if (s != null) continue;
            return Optional.empty();
        }
        return Optional.of(new DefaultRaptorTransfer(this.toStop, (int)s.getElapsedTimeSeconds(), RaptorCostConverter.toRaptorCost(s.getWeight()), this));
    }
}

