/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.util.lang.ToStringBuilder;

public class DefaultAccessEgress
implements RaptorAccessEgress {
    private final int stop;
    private final int durationInSeconds;
    private final int generalizedCost;
    private final State lastState;

    public DefaultAccessEgress(int stop, State lastState) {
        this.stop = stop;
        this.durationInSeconds = (int)lastState.getElapsedTimeSeconds();
        this.generalizedCost = RaptorCostConverter.toRaptorCost(lastState.getWeight());
        this.lastState = lastState;
    }

    @Override
    public boolean hasOpeningHours() {
        return false;
    }

    @Override
    public int durationInSeconds() {
        return this.durationInSeconds;
    }

    @Override
    public int stop() {
        return this.stop;
    }

    @Override
    public int generalizedCost() {
        return this.generalizedCost;
    }

    public State getLastState() {
        return this.lastState;
    }

    public String toString() {
        return ToStringBuilder.of(DefaultAccessEgress.class).addNum("stop", this.stop).addNum("durationInSeconds", this.durationInSeconds).addNum("generalizedCost", this.generalizedCost).addObj("state", this.lastState).toString();
    }
}

