/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router.performance;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.routing.api.request.RoutingTag;
import org.opentripplanner.routing.framework.MicrometerUtils;
import org.opentripplanner.transit.raptor.api.debug.RaptorTimers;

public class PerformanceTimersForRaptor
implements RaptorTimers {
    private final Timer timerRoute;
    private final Timer findTransitPerRound;
    private final Timer findTransfersPerRound;
    private final MeterRegistry registry;
    private final Collection<RoutingTag> routingTags;

    public PerformanceTimersForRaptor(String namePrefix, Collection<RoutingTag> routingTags, MeterRegistry registry) {
        this.registry = registry;
        this.routingTags = routingTags;
        List<Tag> tags = MicrometerUtils.mapTimingTags(routingTags);
        this.timerRoute = Timer.builder((String)("raptor." + namePrefix + ".route")).tags(tags).register(registry);
        this.findTransitPerRound = Timer.builder((String)("raptor." + namePrefix + ".minute.transit")).tags(tags).register(registry);
        this.findTransfersPerRound = Timer.builder((String)("raptor." + namePrefix + ".minute.transfers")).tags(tags).register(registry);
    }

    public Timer timerRoute() {
        return this.timerRoute;
    }

    public Timer timerFindTransitPerRound() {
        return this.findTransitPerRound;
    }

    public Timer timerFindTransfersPerRound() {
        return this.findTransfersPerRound;
    }

    @Override
    public void route(Runnable body) {
        this.timerRoute.record(body);
    }

    @Override
    public void findTransitForRound(Runnable body) {
        this.findTransitPerRound.record(body);
    }

    @Override
    public void findTransfersForRound(Runnable body) {
        this.findTransfersPerRound.record(body);
    }

    @Override
    public RaptorTimers withNamePrefix(String namePrefix) {
        return new PerformanceTimersForRaptor(namePrefix, this.routingTags, this.registry);
    }
}

