/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.util.List;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.TripPlan;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.LocalizedString;
import org.opentripplanner.transit.model.basic.NonLocalizedString;

public class TripPlanMapper {
    private TripPlanMapper() {
    }

    public static TripPlan mapTripPlan(RouteRequest request, List<Itinerary> itineraries) {
        Place to;
        Place from;
        if (itineraries.isEmpty()) {
            from = TripPlanMapper.placeFromGeoLocation(request.from(), new LocalizedString("origin"));
            to = TripPlanMapper.placeFromGeoLocation(request.to(), new LocalizedString("destination"));
        } else {
            List<Leg> legs = itineraries.get(0).getLegs();
            from = legs.get(0).getFrom();
            to = legs.get(legs.size() - 1).getTo();
        }
        return new TripPlan(from, to, request.dateTime(), itineraries);
    }

    private static Place placeFromGeoLocation(GenericLocation location, I18NString defaultName) {
        return Place.normal(location.lat, location.lng, NonLocalizedString.ofNullableOrElse(location.label, defaultName));
    }
}

