/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.DirectionUtils;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.VehicleRentalStationInfo;
import org.opentripplanner.model.plan.RelativeDirection;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.AreaEdge;
import org.opentripplanner.routing.edgetype.ElevatorAlightEdge;
import org.opentripplanner.routing.edgetype.FreeEdge;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.routing.vertextype.ExitVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalPlaceVertex;
import org.opentripplanner.transit.model.basic.WgsCoordinate;

public class StatesToWalkStepsMapper {
    private static final double MAX_ZAG_DISTANCE = 30.0;
    private final double ellipsoidToGeoidDifference;
    private final StreetNotesService streetNotesService;
    private final List<State> states;
    private final WalkStep previous;
    private final List<WalkStep> steps = new ArrayList<WalkStep>();
    private WalkStep current = null;
    private double lastAngle = 0.0;
    private double distance = 0.0;
    private int roundaboutExit = 0;
    private String roundaboutPreviousStreet = null;

    public StatesToWalkStepsMapper(List<State> states, WalkStep previousStep, StreetNotesService streetNotesService, double ellipsoidToGeoidDifference) {
        this.states = states;
        this.previous = previousStep;
        this.streetNotesService = streetNotesService;
        this.ellipsoidToGeoidDifference = ellipsoidToGeoidDifference;
    }

    public static String getNormalizedName(String streetName) {
        if (streetName == null) {
            return null;
        }
        int idx = streetName.indexOf(40);
        if (idx > 0) {
            return streetName.substring(0, idx - 1);
        }
        return streetName;
    }

    public List<WalkStep> generateWalkSteps() {
        for (int i = 0; i < this.states.size() - 1; ++i) {
            this.processState(this.states.get(i), this.states.get(i + 1));
        }
        if (this.steps.isEmpty()) {
            return this.steps;
        }
        if (GraphPathToItineraryMapper.isRentalPickUp(this.states.get(this.states.size() - 1))) {
            VehicleRentalPlaceVertex vertex = (VehicleRentalPlaceVertex)this.states.get(this.states.size() - 1).getVertex();
            this.steps.get(this.steps.size() - 1).setVehicleRentalOffStation(new VehicleRentalStationInfo(vertex));
        }
        if (GraphPathToItineraryMapper.isRentalDropOff(this.states.get(0))) {
            VehicleRentalPlaceVertex vertex = (VehicleRentalPlaceVertex)this.states.get(0).getVertex();
            this.steps.get(0).setVehicleRentalOffStation(new VehicleRentalStationInfo(vertex));
        }
        return this.steps;
    }

    private static boolean isUTurn(WalkStep twoBack, WalkStep lastStep) {
        RelativeDirection d1 = lastStep.getRelativeDirection();
        RelativeDirection d2 = twoBack.getRelativeDirection();
        return !((d1 != RelativeDirection.RIGHT && d1 != RelativeDirection.HARD_RIGHT || d2 != RelativeDirection.RIGHT && d2 != RelativeDirection.HARD_RIGHT) && (d1 != RelativeDirection.LEFT && d1 != RelativeDirection.HARD_LEFT || d2 != RelativeDirection.LEFT && d2 != RelativeDirection.HARD_LEFT));
    }

    private static double getAbsoluteAngleDiff(double thisAngle, double lastAngle) {
        double ccwAngleDiff;
        double angleDiff = thisAngle - lastAngle;
        if (angleDiff < 0.0) {
            angleDiff += Math.PI * 2;
        }
        if ((ccwAngleDiff = Math.PI * 2 - angleDiff) < angleDiff) {
            angleDiff = ccwAngleDiff;
        }
        return angleDiff;
    }

    private static boolean isLink(Edge edge) {
        return edge instanceof StreetEdge && (((StreetEdge)edge).getStreetClass() & 0x20) == 32;
    }

    private static List<P2<Double>> encodeElevationProfile(Edge edge, double distanceOffset, double heightOffset) {
        if (!(edge instanceof StreetEdge)) {
            return new ArrayList<P2<Double>>();
        }
        StreetEdge elevEdge = (StreetEdge)edge;
        if (elevEdge.getElevationProfile() == null) {
            return new ArrayList<P2<Double>>();
        }
        ArrayList<P2<Double>> out = new ArrayList<P2<Double>>();
        for (Coordinate coordinate : elevEdge.getElevationProfile().toCoordinateArray()) {
            out.add(new P2<Double>(coordinate.x + distanceOffset, coordinate.y + heightOffset));
        }
        return out;
    }

    private void processState(State backState, State forwardState) {
        boolean modeTransition;
        Edge edge = forwardState.getBackEdge();
        boolean createdNewStep = false;
        if (edge instanceof FreeEdge) {
            return;
        }
        if (forwardState.getBackMode() == null) {
            return;
        }
        LineString geom = edge.getGeometry();
        if (geom == null) {
            return;
        }
        if (edge instanceof ElevatorAlightEdge) {
            this.createElevatorWalkStep(backState, forwardState, edge);
            return;
        }
        String streetName = edge.getName().toString();
        String streetNameNoParens = StatesToWalkStepsMapper.getNormalizedName(streetName);
        boolean bl = modeTransition = forwardState.getBackMode() != backState.getBackMode();
        if (this.current == null) {
            this.createFirstStep(backState, forwardState);
            createdNewStep = true;
        } else if (modeTransition || !this.continueOnSameStreet(edge, streetNameNoParens) || edge.isRoundabout() != this.roundaboutExit > 0 || StatesToWalkStepsMapper.isLink(edge) && !StatesToWalkStepsMapper.isLink(backState.getBackEdge())) {
            if (this.roundaboutExit > 0) {
                this.current.setExit(Integer.toString(this.roundaboutExit));
                if (streetNameNoParens.equals(this.roundaboutPreviousStreet)) {
                    this.current.setStayOn(true);
                }
                this.roundaboutExit = 0;
            }
            this.current = this.createWalkStep(forwardState, backState);
            createdNewStep = true;
            this.steps.add(this.current);
            if (edge.isRoundabout()) {
                this.roundaboutExit = 1;
                this.roundaboutPreviousStreet = StatesToWalkStepsMapper.getNormalizedName(backState.getBackEdge().getName().toString());
            }
            thisAngle = DirectionUtils.getFirstAngle((Geometry)geom);
            this.current.setDirections(this.lastAngle, thisAngle, edge.isRoundabout());
            this.distance = edge.getDistanceMeters();
        } else {
            thisAngle = DirectionUtils.getFirstAngle((Geometry)geom);
            RelativeDirection direction = RelativeDirection.calculate(this.lastAngle, thisAngle, edge.isRoundabout());
            if (edge.isRoundabout()) {
                if (StatesToWalkStepsMapper.multipleTurnOptionsInPreviousState(backState)) {
                    ++this.roundaboutExit;
                }
            } else if (direction != RelativeDirection.CONTINUE && this.isPossibleToTurnToOtherStreet(backState, edge, streetName, thisAngle)) {
                this.current = this.createWalkStep(forwardState, backState);
                createdNewStep = true;
                this.steps.add(this.current);
                this.current.setDirections(this.lastAngle, thisAngle, false);
                this.current.setStayOn(true);
                this.distance = edge.getDistanceMeters();
            }
        }
        this.setMotorwayExit(backState);
        if (createdNewStep && !modeTransition) {
            int lastIndex = this.steps.size() - 1;
            if (lastIndex >= 2) {
                WalkStep threeBack = this.steps.get(lastIndex - 2);
                WalkStep twoBack = this.steps.get(lastIndex - 1);
                WalkStep lastStep = this.steps.get(lastIndex);
                boolean isOnSameStreet = lastStep.streetNameNoParens().equals(threeBack.streetNameNoParens());
                if (twoBack.getDistance() < 30.0 && isOnSameStreet) {
                    if (StatesToWalkStepsMapper.isUTurn(twoBack, lastStep)) {
                        this.steps.remove(lastIndex - 1);
                        this.processUTurn(lastStep, twoBack);
                    } else {
                        this.steps.remove(lastIndex);
                        this.steps.remove(lastIndex - 1);
                        this.removeZag(threeBack, twoBack);
                    }
                }
            }
        } else {
            if (!createdNewStep && this.current.getRawElevation() != null) {
                this.updateElevationProfile(backState, edge);
            }
            this.distance += edge.getDistanceMeters();
        }
        this.current.addDistance(edge.getDistanceMeters());
        this.current.addStreetNotes(this.streetNotesService.getNotes(forwardState));
        this.lastAngle = DirectionUtils.getLastAngle((Geometry)geom);
        this.current.getEdges().add(edge);
    }

    private void updateElevationProfile(State backState, Edge edge) {
        List<P2<Double>> s = StatesToWalkStepsMapper.encodeElevationProfile(edge, this.distance, backState.getPreferences().system().geoidElevation() ? -this.ellipsoidToGeoidDifference : 0.0);
        this.current.addElevation(s);
    }

    private void removeZag(WalkStep threeBack, WalkStep twoBack) {
        this.current = threeBack;
        this.current.addDistance(twoBack.getDistance());
        this.distance += this.current.getDistance();
        if (twoBack.getRawElevation() != null) {
            if (this.current.getRawElevation() == null) {
                this.current.addElevation(twoBack.getRawElevation());
            } else {
                this.current.addElevation(twoBack.getRawElevation().stream().map(p -> new P2<Double>((Double)p.first + this.current.getDistance(), (Double)p.second)).toList());
            }
        }
    }

    private void processUTurn(WalkStep lastStep, WalkStep twoBack) {
        lastStep.addDistance(twoBack.getDistance());
        if (lastStep.getRelativeDirection() == RelativeDirection.LEFT || lastStep.getRelativeDirection() == RelativeDirection.HARD_LEFT) {
            lastStep.setRelativeDirection(RelativeDirection.UTURN_LEFT);
        } else {
            lastStep.setRelativeDirection(RelativeDirection.UTURN_RIGHT);
        }
        lastStep.setStayOn(true);
    }

    private void setMotorwayExit(State backState) {
        State exitState = backState;
        Edge exitEdge = exitState.getBackEdge();
        while (exitEdge instanceof FreeEdge) {
            exitState = exitState.getBackState();
            exitEdge = exitState.getBackEdge();
        }
        if (exitState.getVertex() instanceof ExitVertex) {
            this.current.setExit(((ExitVertex)exitState.getVertex()).getExitName());
        }
    }

    private boolean isPossibleToTurnToOtherStreet(State backState, Edge edge, String streetName, double thisAngle) {
        if (edge instanceof StreetEdge) {
            double angleDiff = StatesToWalkStepsMapper.getAbsoluteAngleDiff(thisAngle, this.lastAngle);
            for (StreetEdge alternative : backState.getVertex().getOutgoingStreetEdges()) {
                if (!this.isTurnToOtherStreet(streetName, angleDiff, alternative)) continue;
                return true;
            }
        } else {
            double angleDiff = StatesToWalkStepsMapper.getAbsoluteAngleDiff(this.lastAngle, thisAngle);
            State twoStatesBack = backState.getBackState();
            Vertex backVertex = twoStatesBack.getVertex();
            for (StreetEdge alternative : backVertex.getOutgoingStreetEdges()) {
                for (StreetEdge innerAlternative : alternative.getToVertex().getOutgoingStreetEdges()) {
                    if (!this.isTurnToOtherStreet(streetName, angleDiff, innerAlternative)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isTurnToOtherStreet(String streetName, double angleDiff, Edge alternative) {
        if (alternative.getName().toString().equals(streetName)) {
            return false;
        }
        double altAngle = DirectionUtils.getFirstAngle((Geometry)alternative.getGeometry());
        double altAngleDiff = StatesToWalkStepsMapper.getAbsoluteAngleDiff(altAngle, this.lastAngle);
        return angleDiff > 0.7853981633974483 || altAngleDiff - angleDiff < 0.19634954084936207;
    }

    private boolean continueOnSameStreet(Edge edge, String streetNameNoParens) {
        return this.current.getStreetName().toString() == null || Objects.equals(this.current.streetNameNoParens(), streetNameNoParens) || this.current.getBogusName() != false && edge.hasBogusName();
    }

    private static boolean multipleTurnOptionsInPreviousState(State state) {
        boolean foundAlternatePaths = false;
        TraverseMode requestedMode = state.getNonTransitMode();
        for (Edge out : state.getBackState().getVertex().getOutgoing()) {
            State outState;
            if (out == state.backEdge || !(out instanceof StreetEdge) || (outState = out.traverse(state.getBackState())) == null || !outState.getBackMode().equals((Object)requestedMode)) continue;
            Vertex tov = outState.getVertex();
            boolean found = false;
            for (Edge out2 : tov.getOutgoing()) {
                State outState2 = out2.traverse(outState);
                if (outState2 != null && !Objects.equals((Object)outState2.getBackMode(), (Object)requestedMode)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            foundAlternatePaths = true;
            break;
        }
        return foundAlternatePaths;
    }

    private void createFirstStep(State backState, State forwardState) {
        this.current = this.createWalkStep(forwardState, backState);
        this.steps.add(this.current);
        Edge edge = forwardState.getBackEdge();
        double thisAngle = DirectionUtils.getFirstAngle((Geometry)edge.getGeometry());
        if (this.previous == null) {
            this.current.setAbsoluteDirection(thisAngle);
            this.current.setRelativeDirection(RelativeDirection.DEPART);
        } else {
            this.current.setDirections(this.previous.getAngle(), thisAngle, false);
        }
        this.distance = edge.getDistanceMeters();
    }

    private void createElevatorWalkStep(State backState, State forwardState, Edge edge) {
        this.current = this.createWalkStep(forwardState, backState);
        this.current.setStreetName(edge.getName());
        this.current.setRelativeDirection(RelativeDirection.ELEVATOR);
        this.steps.add(this.current);
    }

    private WalkStep createWalkStep(State forwardState, State backState) {
        Edge en = forwardState.getBackEdge();
        WalkStep step = new WalkStep(en.getName(), new WgsCoordinate(backState.getVertex().getCoordinate()), en.hasBogusName(), DirectionUtils.getFirstAngle((Geometry)forwardState.getBackEdge().getGeometry()), forwardState.isBackWalkingBike(), forwardState.getBackEdge() instanceof AreaEdge);
        step.addElevation(StatesToWalkStepsMapper.encodeElevationProfile(forwardState.getBackEdge(), 0.0, forwardState.getPreferences().system().geoidElevation() ? -this.ellipsoidToGeoidDifference : 0.0));
        step.addStreetNotes(this.streetNotesService.getNotes(forwardState));
        return step;
    }
}

