/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.model.plan.FrequencyTransitLeg;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultRaptorTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.transferoptimization.api.OptimizedPath;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.core.AStarRequest;
import org.opentripplanner.routing.core.AStarRequestMapper;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.raptor.api.path.AccessPathLeg;
import org.opentripplanner.transit.raptor.api.path.EgressPathLeg;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.path.PathLeg;
import org.opentripplanner.transit.raptor.api.path.TransferPathLeg;
import org.opentripplanner.transit.raptor.api.path.TransitPathLeg;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.geometry.GeometryUtils;

public class RaptorPathToItineraryMapper {
    private final TransitLayer transitLayer;
    private final AStarRequest request;
    private final StreetMode transferMode;
    private final ZonedDateTime transitSearchTimeZero;
    private final GraphPathToItineraryMapper graphPathToItineraryMapper;

    public RaptorPathToItineraryMapper(Graph graph, TransitService transitService, TransitLayer transitLayer, ZonedDateTime transitSearchTimeZero, RouteRequest request) {
        this.transitLayer = transitLayer;
        this.transitSearchTimeZero = transitSearchTimeZero;
        this.transferMode = request.journey().transfer().mode();
        this.request = AStarRequestMapper.map(request.copyAndPrepareForTransferRouting()).withArriveBy(false).withMode(this.transferMode).build();
        this.graphPathToItineraryMapper = new GraphPathToItineraryMapper(transitService.getTimeZone(), graph.streetNotesService, graph.ellipsoidToGeoidDifference);
    }

    public Itinerary createItinerary(Path<TripSchedule> path) {
        OptimizedPath optimizedPath = path instanceof OptimizedPath ? (OptimizedPath)path : null;
        ArrayList<Leg> legs = new ArrayList<Leg>(this.mapAccessLeg(path.accessLeg()));
        PathLeg<TripSchedule> pathLeg = path.accessLeg().nextLeg();
        Leg transitLeg = null;
        while (!pathLeg.isEgressLeg()) {
            if (pathLeg.isTransitLeg()) {
                transitLeg = this.mapTransitLeg(transitLeg, pathLeg.asTransitLeg());
                legs.add(transitLeg);
            } else if (pathLeg.isTransferLeg()) {
                legs.addAll(this.mapTransferLeg(pathLeg.asTransferLeg(), this.transferMode == StreetMode.BIKE ? TraverseMode.BICYCLE : TraverseMode.WALK));
            }
            pathLeg = pathLeg.nextLeg();
        }
        EgressPathLeg<TripSchedule> egressPathLeg = pathLeg.asEgressLeg();
        Itinerary mapped = this.mapEgressLeg(egressPathLeg);
        legs.addAll(mapped == null ? List.of() : mapped.getLegs());
        Itinerary itinerary = new Itinerary(legs);
        itinerary.setGeneralizedCost(RaptorCostConverter.toOtpDomainCost(path.generalizedCost()));
        itinerary.setArrivedAtDestinationWithRentedVehicle(mapped != null && mapped.isArrivedAtDestinationWithRentedVehicle());
        if (optimizedPath != null) {
            itinerary.setWaitTimeOptimizedCost(RaptorCostConverter.toOtpDomainCost(optimizedPath.generalizedCostWaitTimeOptimized()));
            itinerary.setTransferPriorityCost(RaptorCostConverter.toOtpDomainCost(optimizedPath.transferPriorityCost()));
        }
        return itinerary;
    }

    private List<Leg> mapAccessLeg(AccessPathLeg<TripSchedule> accessPathLeg) {
        DefaultAccessEgress accessPath = (DefaultAccessEgress)accessPathLeg.access();
        if (accessPath.durationInSeconds() == 0) {
            return List.of();
        }
        GraphPath graphPath = new GraphPath(accessPath.getLastState());
        Itinerary subItinerary = this.graphPathToItineraryMapper.generateItinerary(graphPath);
        if (subItinerary.getLegs().isEmpty()) {
            return List.of();
        }
        return subItinerary.withTimeShiftToStartAt(this.createZonedDateTime(accessPathLeg.fromTime())).getLegs();
    }

    private Leg mapTransitLeg(Leg prevTransitLeg, TransitPathLeg<TripSchedule> pathLeg) {
        TripSchedule tripSchedule = pathLeg.trip();
        int boardStopIndexInPattern = tripSchedule.findDepartureStopPosition(pathLeg.fromTime(), pathLeg.fromStop());
        int alightStopIndexInPattern = tripSchedule.findArrivalStopPosition(pathLeg.toTime(), pathLeg.toStop());
        if (tripSchedule.isFrequencyBasedTrip()) {
            int frequencyHeadwayInSeconds = tripSchedule.frequencyHeadwayInSeconds();
            return new FrequencyTransitLeg(tripSchedule.getOriginalTripTimes(), tripSchedule.getOriginalTripPattern(), boardStopIndexInPattern, alightStopIndexInPattern, this.createZonedDateTime(pathLeg.fromTime() + frequencyHeadwayInSeconds), this.createZonedDateTime(pathLeg.toTime()), tripSchedule.getServiceDate(), this.transitSearchTimeZero.getZone().normalized(), prevTransitLeg == null ? null : prevTransitLeg.getTransferToNextLeg(), (ConstrainedTransfer)pathLeg.getConstrainedTransferAfterLeg(), RaptorCostConverter.toOtpDomainCost(pathLeg.generalizedCost()), frequencyHeadwayInSeconds, null);
        }
        return new ScheduledTransitLeg(tripSchedule.getOriginalTripTimes(), tripSchedule.getOriginalTripPattern(), boardStopIndexInPattern, alightStopIndexInPattern, this.createZonedDateTime(pathLeg.fromTime()), this.createZonedDateTime(pathLeg.toTime()), tripSchedule.getServiceDate(), this.transitSearchTimeZero.getZone().normalized(), prevTransitLeg == null ? null : prevTransitLeg.getTransferToNextLeg(), (ConstrainedTransfer)pathLeg.getConstrainedTransferAfterLeg(), RaptorCostConverter.toOtpDomainCost(pathLeg.generalizedCost()), null);
    }

    private List<Leg> mapTransferLeg(TransferPathLeg<TripSchedule> pathLeg, TraverseMode transferMode) {
        StopLocation transferFromStop = this.transitLayer.getStopByIndex(pathLeg.fromStop());
        StopLocation transferToStop = this.transitLayer.getStopByIndex(pathLeg.toStop());
        Transfer transfer = ((DefaultRaptorTransfer)pathLeg.transfer()).transfer();
        Place from = Place.forStop(transferFromStop);
        Place to = Place.forStop(transferToStop);
        return this.mapNonTransitLeg(pathLeg, transfer, transferMode, from, to);
    }

    private Itinerary mapEgressLeg(EgressPathLeg<TripSchedule> egressPathLeg) {
        DefaultAccessEgress egressPath = (DefaultAccessEgress)egressPathLeg.egress();
        if (egressPath.durationInSeconds() == 0) {
            return null;
        }
        GraphPath graphPath = new GraphPath(egressPath.getLastState());
        Itinerary subItinerary = this.graphPathToItineraryMapper.generateItinerary(graphPath);
        if (subItinerary.getLegs().isEmpty()) {
            return null;
        }
        return subItinerary.withTimeShiftToStartAt(this.createZonedDateTime(egressPathLeg.fromTime()));
    }

    private List<Leg> mapNonTransitLeg(PathLeg<TripSchedule> pathLeg, Transfer transfer, TraverseMode transferMode, Place from, Place to) {
        List<Edge> edges = transfer.getEdges();
        if (edges == null || edges.isEmpty()) {
            return List.of(StreetLeg.create().withMode(transferMode).withStartTime(this.createZonedDateTime(pathLeg.fromTime())).withEndTime(this.createZonedDateTime(pathLeg.toTime())).withFrom(from).withTo(to).withDistanceMeters(transfer.getDistanceMeters()).withGeneralizedCost(RaptorCostConverter.toOtpDomainCost(pathLeg.generalizedCost())).withGeometry(GeometryUtils.makeLineString(transfer.getCoordinates())).withWalkSteps(List.of()).build());
        }
        StateEditor se = new StateEditor(edges.get(0).getFromVertex(), this.request);
        se.setTimeSeconds(this.createZonedDateTime(pathLeg.fromTime()).toEpochSecond());
        State s = se.makeState();
        ArrayList<State> transferStates = new ArrayList<State>();
        transferStates.add(s);
        for (Edge e : edges) {
            s = e.traverse(s);
            transferStates.add(s);
        }
        State[] states = transferStates.toArray(new State[0]);
        GraphPath graphPath = new GraphPath(states[states.length - 1]);
        Itinerary subItinerary = this.graphPathToItineraryMapper.generateItinerary(graphPath);
        if (subItinerary.getLegs().isEmpty()) {
            return List.of();
        }
        return subItinerary.getLegs();
    }

    private ZonedDateTime createZonedDateTime(int timeInSeconds) {
        return this.transitSearchTimeZero.plusSeconds(timeInSeconds);
    }
}

