/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.api.resource.CoordinateArrayListSequence;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.ext.flex.FlexibleTransitLeg;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.StreetLegBuilder;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.algorithm.mapping.StatesToWalkStepsMapper;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.BoardingLocationToStopLink;
import org.opentripplanner.routing.edgetype.PathwayEdge;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.VehicleParkingEdge;
import org.opentripplanner.routing.edgetype.VehicleRentalEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.location.TemporaryStreetLocation;
import org.opentripplanner.routing.services.notes.StreetNotesService;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalPlaceVertex;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.geometry.GeometryUtils;

public class GraphPathToItineraryMapper {
    private final ZoneId timeZone;
    private final StreetNotesService streetNotesService;
    private final double ellipsoidToGeoidDifference;

    public GraphPathToItineraryMapper(ZoneId timeZone, StreetNotesService streetNotesService, double ellipsoidToGeoidDifference) {
        this.timeZone = timeZone;
        this.streetNotesService = streetNotesService;
        this.ellipsoidToGeoidDifference = ellipsoidToGeoidDifference;
    }

    public static boolean isRentalPickUp(State state) {
        return state.getBackEdge() instanceof VehicleRentalEdge && (state.getBackState() == null || !state.getBackState().isRentingVehicle());
    }

    public static boolean isRentalDropOff(State state) {
        return state.getBackEdge() instanceof VehicleRentalEdge && state.getBackState().isRentingVehicle();
    }

    public List<Itinerary> mapItineraries(List<GraphPath> paths) {
        LinkedList<Itinerary> itineraries = new LinkedList<Itinerary>();
        for (GraphPath path : paths) {
            Itinerary itinerary = this.generateItinerary(path);
            if (itinerary.getLegs().isEmpty()) continue;
            itineraries.add(itinerary);
        }
        return itineraries;
    }

    public Itinerary generateItinerary(GraphPath path) {
        ArrayList<Leg> legs = new ArrayList<Leg>();
        WalkStep previousStep = null;
        for (List<State> legStates : GraphPathToItineraryMapper.sliceStates(path.states)) {
            if (OTPFeature.FlexRouting.isOn() && legStates.get((int)1).backEdge instanceof FlexTripEdge) {
                legs.add(this.generateFlexLeg(legStates));
                previousStep = null;
                continue;
            }
            StreetLeg leg = this.generateLeg(legStates, previousStep);
            legs.add(leg);
            List<WalkStep> walkSteps = leg.getWalkSteps();
            if (walkSteps.size() > 0) {
                previousStep = walkSteps.get(walkSteps.size() - 1);
                continue;
            }
            previousStep = null;
        }
        Itinerary itinerary = new Itinerary(legs);
        GraphPathToItineraryMapper.calculateElevations(itinerary, path.edges);
        State lastState = path.states.getLast();
        itinerary.setGeneralizedCost((int)lastState.weight);
        itinerary.setArrivedAtDestinationWithRentedVehicle(lastState.isRentingVehicleFromStation());
        return itinerary;
    }

    private static CoordinateArrayListSequence makeCoordinates(List<Edge> edges) {
        CoordinateArrayListSequence coordinates = new CoordinateArrayListSequence();
        for (Edge edge : edges) {
            LineString geometry = edge.getGeometry();
            if (geometry == null) continue;
            if (coordinates.size() == 0) {
                coordinates.extend(geometry.getCoordinates());
                continue;
            }
            coordinates.extend(geometry.getCoordinates(), 1);
        }
        return coordinates;
    }

    private static List<List<State>> sliceStates(List<State> states) {
        if (states.stream().allMatch(state -> state.getBackMode() == null)) {
            return List.of();
        }
        LinkedList<List<State>> legsStates = new LinkedList<List<State>>();
        int previousBreak = 0;
        for (int i = 1; i < states.size() - 1; ++i) {
            boolean carPickupChange;
            State backState = states.get(i);
            State forwardState = states.get(i + 1);
            boolean flexChange = forwardState.backEdge instanceof FlexTripEdge || backState.backEdge instanceof FlexTripEdge;
            boolean rentalChange = GraphPathToItineraryMapper.isRentalPickUp(backState) || GraphPathToItineraryMapper.isRentalDropOff(backState);
            boolean parkingChange = backState.isVehicleParked() != forwardState.isVehicleParked();
            boolean bl = carPickupChange = backState.getCarPickupState() != forwardState.getCarPickupState();
            if (!parkingChange && !flexChange && !rentalChange && !carPickupChange) continue;
            int nextBreak = i;
            if (nextBreak > previousBreak) {
                legsStates.add(states.subList(previousBreak, nextBreak + 1));
            }
            if (parkingChange) {
                // empty if block
            }
            previousBreak = ++nextBreak;
        }
        if (states.size() > previousBreak) {
            legsStates.add(states.subList(previousBreak, states.size()));
        }
        return legsStates;
    }

    private static StreetLegBuilder setPathwayInfo(StreetLegBuilder leg, List<State> legStates) {
        for (State legsState : legStates) {
            Edge edge = legsState.getBackEdge();
            if (!(edge instanceof PathwayEdge)) continue;
            PathwayEdge pe = (PathwayEdge)edge;
            leg.withPathwayId(pe.getId());
        }
        return leg;
    }

    private static void calculateElevations(Itinerary itinerary, List<Edge> edges) {
        for (Edge edge : edges) {
            StreetEdge edgeWithElevation;
            PackedCoordinateSequence coordinates;
            if (!(edge instanceof StreetEdge) || (coordinates = (edgeWithElevation = (StreetEdge)edge).getElevationProfile()) == null || coordinates.getDimension() != 2) continue;
            for (int i = 0; i < coordinates.size() - 1; ++i) {
                double change = coordinates.getOrdinate(i + 1, 1) - coordinates.getOrdinate(i, 1);
                if (change > 0.0) {
                    itinerary.setElevationGained(itinerary.getElevationGained() + change);
                    continue;
                }
                if (!(change < 0.0)) continue;
                itinerary.setElevationLost(itinerary.getElevationLost() - change);
            }
        }
    }

    private static TraverseMode resolveMode(List<State> states) {
        return states.stream().skip(1L).map(state -> {
            TraverseMode mode = state.getNonTransitMode();
            if (mode != null) {
                if (state.isRentingVehicle()) {
                    return switch (state.stateData.rentalVehicleFormFactor) {
                        default -> throw new IncompatibleClassChangeError();
                        case RentalVehicleType.FormFactor.BICYCLE, RentalVehicleType.FormFactor.OTHER -> TraverseMode.BICYCLE;
                        case RentalVehicleType.FormFactor.SCOOTER, RentalVehicleType.FormFactor.MOPED -> TraverseMode.SCOOTER;
                        case RentalVehicleType.FormFactor.CAR -> TraverseMode.CAR;
                    };
                }
                return mode;
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(TraverseMode.WALK);
    }

    private static List<P2<Double>> encodeElevationProfileWithNaN(Edge edge, double distanceOffset, double heightOffset) {
        List<P2<Double>> elevations = GraphPathToItineraryMapper.encodeElevationProfile(edge, distanceOffset, heightOffset);
        if (elevations.isEmpty()) {
            return List.of(new P2<Double>(distanceOffset, Double.NaN), new P2<Double>(distanceOffset + edge.getDistanceMeters(), Double.NaN));
        }
        return elevations;
    }

    private static List<P2<Double>> encodeElevationProfile(Edge edge, double distanceOffset, double heightOffset) {
        Coordinate[] coordArr;
        ArrayList<P2<Double>> out = new ArrayList<P2<Double>>();
        if (!(edge instanceof StreetEdge)) {
            return out;
        }
        StreetEdge elevEdge = (StreetEdge)edge;
        if (elevEdge.getElevationProfile() == null) {
            return out;
        }
        for (Coordinate coordinate : coordArr = elevEdge.getElevationProfile().toCoordinateArray()) {
            out.add(new P2<Double>(coordinate.x + distanceOffset, coordinate.y + heightOffset));
        }
        return out;
    }

    private static Place makePlace(State state) {
        Vertex vertex = state.getVertex();
        I18NString name = vertex.getName();
        if (vertex instanceof StreetVertex && !(vertex instanceof TemporaryStreetLocation)) {
            name = ((StreetVertex)vertex).getIntersectionName();
        }
        if (vertex instanceof TransitStopVertex) {
            return Place.forStop(((TransitStopVertex)vertex).getStop());
        }
        if (vertex instanceof VehicleRentalPlaceVertex) {
            return Place.forVehicleRentalPlace((VehicleRentalPlaceVertex)vertex);
        }
        if (vertex instanceof VehicleParkingEntranceVertex) {
            return Place.forVehicleParkingEntrance((VehicleParkingEntranceVertex)vertex, state);
        }
        return Place.normal(vertex, name);
    }

    private Leg generateFlexLeg(List<State> states) {
        State fromState = states.get(0);
        State toState = states.get(1);
        FlexTripEdge flexEdge = (FlexTripEdge)toState.backEdge;
        ZonedDateTime startTime = fromState.getTime().atZone(this.timeZone);
        ZonedDateTime endTime = toState.getTime().atZone(this.timeZone);
        int generalizedCost = (int)(toState.getWeight() - fromState.getWeight());
        return new FlexibleTransitLeg(flexEdge, startTime, endTime, generalizedCost);
    }

    private StreetLeg generateLeg(List<State> states, WalkStep previousStep) {
        String vehicleRentalNetwork;
        List<Edge> edges = states.stream().skip(1L).filter(e -> !(e.backEdge instanceof BoardingLocationToStopLink)).map(State::getBackEdge).toList();
        State firstState = states.get(0);
        State lastState = states.get(states.size() - 1);
        double distanceMeters = edges.stream().mapToDouble(Edge::getDistanceMeters).sum();
        CoordinateArrayListSequence coordinates = GraphPathToItineraryMapper.makeCoordinates(edges);
        LineString geometry = GeometryUtils.getGeometryFactory().createLineString((CoordinateSequence)coordinates);
        StatesToWalkStepsMapper statesToWalkStepsMapper = new StatesToWalkStepsMapper(states, previousStep, this.streetNotesService, this.ellipsoidToGeoidDifference);
        List<WalkStep> walkSteps = statesToWalkStepsMapper.generateWalkSteps();
        boolean previousStateIsVehicleParking = firstState.getBackState() != null && firstState.getBackEdge() instanceof VehicleParkingEdge;
        State startTimeState = previousStateIsVehicleParking ? firstState.getBackState() : firstState;
        StreetLegBuilder leg = StreetLeg.create().withMode(GraphPathToItineraryMapper.resolveMode(states)).withStartTime(startTimeState.getTime().atZone(this.timeZone)).withEndTime(lastState.getTime().atZone(this.timeZone)).withFrom(GraphPathToItineraryMapper.makePlace(firstState)).withTo(GraphPathToItineraryMapper.makePlace(lastState)).withDistanceMeters(distanceMeters).withGeneralizedCost((int)(lastState.getWeight() - firstState.getWeight())).withGeometry(geometry).withElevation(this.makeElevation(edges, firstState.getPreferences().system().geoidElevation())).withWalkSteps(walkSteps).withRentedVehicle(firstState.isRentingVehicle()).withWalkingBike(false);
        if (firstState.isRentingVehicle() && (vehicleRentalNetwork = firstState.getVehicleRentalNetwork()) != null) {
            leg.withVehicleRentalNetwork(vehicleRentalNetwork);
        }
        this.addStreetNotes(leg, states);
        GraphPathToItineraryMapper.setPathwayInfo(leg, states);
        return leg.build();
    }

    private StreetLegBuilder addStreetNotes(StreetLegBuilder leg, List<State> states) {
        for (State state : states) {
            Set<StreetNote> streetNotes = this.streetNotesService.getNotes(state);
            if (streetNotes == null) continue;
            leg.withStreetNotes(streetNotes);
        }
        return leg;
    }

    private List<P2<Double>> makeElevation(List<Edge> edges, boolean geoidElevation) {
        ArrayList<P2<Double>> elevationProfile = new ArrayList<P2<Double>>();
        double heightOffset = geoidElevation ? this.ellipsoidToGeoidDifference : 0.0;
        double distanceOffset = 0.0;
        for (Edge edge : edges) {
            if (!(edge.getDistanceMeters() > 0.0)) continue;
            elevationProfile.addAll(GraphPathToItineraryMapper.encodeElevationProfileWithNaN(edge, distanceOffset, heightOffset));
            distanceOffset += edge.getDistanceMeters();
        }
        for (int i = elevationProfile.size() - 3; i >= 0; --i) {
            P2 first = (P2)elevationProfile.get(i);
            P2<Double> second = elevationProfile.get(i + 1);
            P2<Double> third = elevationProfile.get(i + 2);
            if (Objects.equals(first.second, second.second) && Objects.equals(second.second, third.second)) {
                elevationProfile.remove(i + 1);
                continue;
            }
            if (((Double)first.second).isNaN() && ((Double)second.second).isNaN() && ((Double)third.second).isNaN()) {
                elevationProfile.remove(i + 1);
                continue;
            }
            if (!Objects.equals(first, second)) continue;
            elevationProfile.remove(i + 1);
        }
        if (elevationProfile.stream().allMatch(p2 -> ((Double)p2.second).isNaN())) {
            return null;
        }
        return elevationProfile;
    }
}

