/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.groupids;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupId;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class GroupBySameFirstOrLastTrip
implements GroupId<GroupBySameFirstOrLastTrip> {
    private final List<Leg> keySet;

    public GroupBySameFirstOrLastTrip(Itinerary itinerary) {
        this.keySet = itinerary.getLegs().stream().filter(Leg::isTransitLeg).collect(Collectors.toList());
    }

    @Override
    public boolean match(GroupBySameFirstOrLastTrip other) {
        if (this == other) {
            return true;
        }
        if (this.keySet.isEmpty() || other.keySet.isEmpty()) {
            return false;
        }
        return GroupBySameFirstOrLastTrip.isTheSame(this.keySet, other.keySet);
    }

    @Override
    public GroupBySameFirstOrLastTrip merge(GroupBySameFirstOrLastTrip other) {
        return this;
    }

    List<Leg> getKeySet() {
        return List.copyOf(this.keySet);
    }

    private static boolean isTheSame(List<Leg> a, List<Leg> b) {
        Leg firstLegA = a.get(0);
        Leg firstLegB = b.get(0);
        Leg lastLegA = a.get(a.size() - 1);
        Leg lastLegB = b.get(b.size() - 1);
        return GroupBySameFirstOrLastTrip.isTheSame(firstLegA, firstLegB) || GroupBySameFirstOrLastTrip.isTheSame(lastLegA, lastLegB);
    }

    private static boolean isTheSame(Leg a, Leg b) {
        FeedScopedId idB;
        FeedScopedId idA = a.getTrip() != null ? a.getTrip().getId() : null;
        FeedScopedId feedScopedId = idB = b.getTrip() != null ? b.getTrip().getId() : null;
        if (!Objects.equals(idA, idB)) {
            return false;
        }
        return Objects.equals(a.getServiceDate(), b.getServiceDate());
    }
}

