/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;

public class RemoveTransitIfStreetOnlyIsBetterFilter
implements ItineraryDeletionFlagger {
    public static final String TAG = "transit-vs-street-filter";

    @Override
    public String name() {
        return TAG;
    }

    @Override
    public List<Itinerary> flagForRemoval(List<Itinerary> itineraries) {
        Optional<Itinerary> bestStreetOp = itineraries.stream().filter(Itinerary::isOnStreetAllTheWay).min(Comparator.comparingInt(Itinerary::getGeneralizedCost));
        if (bestStreetOp.isEmpty()) {
            return List.of();
        }
        long limit = bestStreetOp.get().getGeneralizedCost();
        return itineraries.stream().filter(it -> !it.isOnStreetAllTheWay() && (long)it.getGeneralizedCost() >= limit).collect(Collectors.toList());
    }

    @Override
    public boolean skipAlreadyFlaggedItineraries() {
        return false;
    }
}

