/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.deletionflagger;

import java.util.function.Predicate;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.ItineraryDeletionFlagger;

public class RemoveBikerentalWithMostlyWalkingFilter
implements ItineraryDeletionFlagger {
    private final double bikeRentalDistanceRatio;

    public RemoveBikerentalWithMostlyWalkingFilter(double bikeRentalDistanceRatio) {
        this.bikeRentalDistanceRatio = bikeRentalDistanceRatio;
    }

    @Override
    public String name() {
        return "bikerental-vs-walk-filter";
    }

    @Override
    public Predicate<Itinerary> shouldBeFlaggedForRemoval() {
        return itinerary -> {
            boolean containsTransit = itinerary.getLegs().stream().anyMatch(l -> l != null && l.isTransitLeg());
            double bikeRentalDistance = itinerary.getLegs().stream().filter(l -> l.getRentedVehicle() != null && l.getRentedVehicle() != false).mapToDouble(Leg::getDistanceMeters).sum();
            double totalDistance = itinerary.distanceMeters();
            return bikeRentalDistance != 0.0 && !containsTransit && bikeRentalDistance / totalDistance <= this.bikeRentalDistanceRatio;
        };
    }
}

