/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilter;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;

public class ItineraryListFilterChain {
    private final List<ItineraryListFilter> filters;
    private final boolean debug;
    private final List<RoutingError> routingErrors = new ArrayList<RoutingError>();

    public ItineraryListFilterChain(List<ItineraryListFilter> filters, boolean debug) {
        this.filters = filters;
        this.debug = debug;
    }

    public List<Itinerary> filter(List<Itinerary> itineraries) {
        List<Itinerary> result = itineraries;
        for (ItineraryListFilter filter : this.filters) {
            result = filter.filter(result);
        }
        Predicate<Itinerary> isOnStreetAllTheWay = Itinerary::isOnStreetAllTheWay;
        boolean hasTransitItineraries = itineraries.stream().anyMatch(Predicate.not(isOnStreetAllTheWay));
        boolean allTransitItinerariesDeleted = result.stream().filter(Predicate.not(isOnStreetAllTheWay)).allMatch(Itinerary::isFlaggedForDeletion);
        if (hasTransitItineraries && allTransitItinerariesDeleted) {
            Predicate<Itinerary> isWorseThanStreet = it -> it.getSystemNotices().stream().anyMatch(notice -> notice.tag.equals("transit-vs-street-filter"));
            Predicate<Itinerary> isOutsideSearchWindow = it -> it.getSystemNotices().stream().anyMatch(notice -> notice.tag.equals("latest-departure-time-limit"));
            if (result.stream().allMatch(isOnStreetAllTheWay.or(isWorseThanStreet))) {
                this.routingErrors.add(new RoutingError(RoutingErrorCode.WALKING_BETTER_THAN_TRANSIT, null));
            } else if (result.stream().allMatch(isOnStreetAllTheWay.or(isOutsideSearchWindow))) {
                this.routingErrors.add(new RoutingError(RoutingErrorCode.NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW, InputField.DATE_TIME));
            }
        }
        if (this.debug) {
            return result;
        }
        return result.stream().filter(Predicate.not(Itinerary::isFlaggedForDeletion)).collect(Collectors.toList());
    }

    public List<RoutingError> getRoutingErrors() {
        return this.routingErrors;
    }
}

