/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.astar.strategies;

import java.util.Set;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.routing.algorithm.astar.strategies.RemainingWeightHeuristic;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.VehicleRentalState;
import org.opentripplanner.routing.edgetype.FreeEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;

public class EuclideanRemainingWeightHeuristic
implements RemainingWeightHeuristic {
    private double lat;
    private double lon;
    private double maxStreetSpeed;
    private double walkingSpeed;
    private boolean arriveBy;

    @Override
    public void initialize(RouteRequest request, StreetMode streetMode, Set<Vertex> fromVertices, Set<Vertex> toVertices) {
        Edge edge;
        Vertex target = toVertices.iterator().next();
        this.maxStreetSpeed = this.getStreetSpeedUpperBound(request.preferences(), streetMode);
        this.walkingSpeed = request.preferences().walk().speed();
        this.arriveBy = request.arriveBy();
        if (target.getDegreeIn() == 1 && (edge = target.getIncoming().iterator().next()) instanceof FreeEdge) {
            target = edge.getFromVertex();
        }
        this.lat = target.getLat();
        this.lon = target.getLon();
    }

    private double getStreetSpeedUpperBound(RoutingPreferences preferences, StreetMode streetMode) {
        if (streetMode.includesDriving()) {
            return preferences.car().speed();
        }
        if (streetMode.includesBiking()) {
            return preferences.bike().speed();
        }
        return preferences.walk().speed();
    }

    @Override
    public double estimateRemainingWeight(State s) {
        Vertex sv = s.getVertex();
        double euclideanDistance = SphericalDistanceLibrary.fastDistance(sv.getLat(), sv.getLon(), this.lat, this.lon);
        boolean useWalkSpeed = this.arriveBy ? s.getVehicleRentalState() == VehicleRentalState.BEFORE_RENTING : s.isVehicleParked() || s.getVehicleRentalState() == VehicleRentalState.HAVE_RENTED;
        double streetSpeed = useWalkSpeed ? this.walkingSpeed : this.maxStreetSpeed;
        return euclideanDistance / streetSpeed;
    }
}

