/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.alertpatch;

import java.time.LocalDate;
import java.util.Objects;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.Direction;

public interface EntitySelector {

    public static class StopAndRouteOrTripKey {
        public final FeedScopedId stop;
        public final FeedScopedId routeOrTrip;
        public final LocalDate serviceDate;
        private final transient int hash;

        public StopAndRouteOrTripKey(FeedScopedId stop, FeedScopedId routeOrTrip) {
            this(stop, routeOrTrip, null);
        }

        public StopAndRouteOrTripKey(FeedScopedId stop, FeedScopedId routeOrTrip, LocalDate serviceDate) {
            this.stop = stop;
            this.routeOrTrip = routeOrTrip;
            this.serviceDate = serviceDate;
            this.hash = Objects.hash(stop, serviceDate, routeOrTrip);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StopAndRouteOrTripKey that = (StopAndRouteOrTripKey)o;
            if (!this.stop.equals(that.stop)) {
                return false;
            }
            if (!this.routeOrTrip.equals(that.routeOrTrip)) {
                return false;
            }
            return Objects.equals(this.serviceDate, that.serviceDate);
        }
    }

    public static class DirectionAndRoute
    implements EntitySelector {
        public final Direction direction;
        public final FeedScopedId routeId;

        public DirectionAndRoute(Direction direction, FeedScopedId routeId) {
            this.direction = direction;
            this.routeId = routeId;
        }

        public int hashCode() {
            int routeHash = Objects.hash(this.routeId);
            return 41 * this.direction.ordinal() * routeHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DirectionAndRoute that = (DirectionAndRoute)o;
            return this.direction == that.direction && this.routeId.equals(that.routeId);
        }
    }

    public static class RouteTypeAndAgency
    implements EntitySelector {
        public final int routeType;
        public final FeedScopedId agencyId;

        public RouteTypeAndAgency(int routeType, FeedScopedId agencyId) {
            this.routeType = routeType;
            this.agencyId = agencyId;
        }

        public int hashCode() {
            int agencyHash = Objects.hash(this.agencyId);
            return 37 * this.routeType * agencyHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteTypeAndAgency that = (RouteTypeAndAgency)o;
            return this.routeType == that.routeType && this.agencyId.equals(that.agencyId);
        }
    }

    public static class RouteType
    implements EntitySelector {
        public final int routeType;
        public final String feedId;

        public RouteType(int routeType, String feedId) {
            this.routeType = routeType;
            this.feedId = feedId;
        }

        public int hashCode() {
            return 37 * this.routeType * Objects.hash(this.feedId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteType that = (RouteType)o;
            return this.routeType == that.routeType && this.feedId.equals(that.feedId);
        }
    }

    public static class Unknown
    implements EntitySelector {
        public final String description;

        public Unknown(String description) {
            this.description = description;
        }

        public int hashCode() {
            return Objects.hash(this.description);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unknown that = (Unknown)o;
            return this.description.equals(that.description);
        }
    }

    public static class StopAndTrip
    implements EntitySelector {
        public final StopAndRouteOrTripKey stopAndTrip;

        public StopAndTrip(FeedScopedId stopId, FeedScopedId tripId) {
            this(stopId, tripId, null);
        }

        public StopAndTrip(FeedScopedId stopId, FeedScopedId tripId, LocalDate serviceDate) {
            this.stopAndTrip = new StopAndRouteOrTripKey(stopId, tripId, serviceDate);
        }

        public int hashCode() {
            return this.stopAndTrip.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StopAndTrip that = (StopAndTrip)o;
            return this.stopAndTrip.equals(that.stopAndTrip);
        }
    }

    public static class StopAndRoute
    implements EntitySelector {
        public final StopAndRouteOrTripKey stopAndRoute;

        public StopAndRoute(FeedScopedId stopId, FeedScopedId routeId) {
            this.stopAndRoute = new StopAndRouteOrTripKey(stopId, routeId);
        }

        public int hashCode() {
            return this.stopAndRoute.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StopAndRoute that = (StopAndRoute)o;
            return this.stopAndRoute.equals(that.stopAndRoute);
        }
    }

    public static class Trip
    implements EntitySelector {
        public final FeedScopedId tripId;
        public final LocalDate serviceDate;
        private transient int hash = -1;

        public Trip(FeedScopedId tripId) {
            this(tripId, null);
        }

        public Trip(FeedScopedId tripId, LocalDate serviceDate) {
            this.tripId = tripId;
            this.serviceDate = serviceDate;
        }

        public int hashCode() {
            if (this.hash == -1) {
                int serviceDateResult = this.serviceDate == null ? 0 : this.serviceDate.hashCode();
                this.hash = 31 * serviceDateResult + this.tripId.hashCode();
            }
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trip trip = (Trip)o;
            if (this.serviceDate != null && trip.serviceDate != null && !this.serviceDate.equals(trip.serviceDate)) {
                return false;
            }
            return this.tripId.equals(trip.tripId);
        }
    }

    public static class Route
    implements EntitySelector {
        public final FeedScopedId routeId;

        public Route(FeedScopedId routeId) {
            this.routeId = routeId;
        }

        public int hashCode() {
            return this.routeId.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Route route = (Route)o;
            return this.routeId.equals(route.routeId);
        }
    }

    public static class Stop
    implements EntitySelector {
        public final FeedScopedId stopId;

        public Stop(FeedScopedId stopId) {
            this.stopId = stopId;
        }

        public int hashCode() {
            return this.stopId.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stop stop = (Stop)o;
            return this.stopId.equals(stop.stopId);
        }
    }

    public static class Agency
    implements EntitySelector {
        public final FeedScopedId agencyId;

        public Agency(FeedScopedId agencyId) {
            this.agencyId = agencyId;
        }

        public int hashCode() {
            return this.agencyId.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Agency agency = (Agency)o;
            return this.agencyId.equals(agency.agencyId);
        }
    }
}

