/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opentripplanner.graph_builder.module.osm.TemplateLibrary;
import org.opentripplanner.openstreetmap.model.OSMProvider;
import org.opentripplanner.openstreetmap.model.OSMTag;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.basic.TranslatedString;
import org.opentripplanner.util.lang.ToStringBuilder;

public class OSMWithTags {
    private Map<String, String> tags;
    protected long id;
    protected I18NString creativeName;
    private OSMProvider osmProvider;

    public static boolean isFalse(String tagValue) {
        return "no".equals(tagValue) || "0".equals(tagValue) || "false".equals(tagValue);
    }

    public static boolean isTrue(String tagValue) {
        return "yes".equals(tagValue) || "1".equals(tagValue) || "true".equals(tagValue);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void addTag(OSMTag tag) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(tag.getK().toLowerCase(), tag.getV());
    }

    public void addTag(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key.toLowerCase(), value);
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean hasTag(String tag) {
        tag = tag.toLowerCase();
        return this.tags != null && this.tags.containsKey(tag);
    }

    public boolean isTagFalse(String tag) {
        tag = tag.toLowerCase();
        if (this.tags == null) {
            return false;
        }
        return OSMWithTags.isFalse(this.getTag(tag));
    }

    public Accessibility getWheelchairAccessibility() {
        if (this.isTagTrue("wheelchair")) {
            return Accessibility.POSSIBLE;
        }
        if (this.isTagFalse("wheelchair")) {
            return Accessibility.NOT_POSSIBLE;
        }
        return Accessibility.NO_INFORMATION;
    }

    public boolean isTagTrue(String tag) {
        tag = tag.toLowerCase();
        if (this.tags == null) {
            return false;
        }
        return OSMWithTags.isTrue(this.getTag(tag));
    }

    public boolean doesTagAllowAccess(String tag) {
        if (this.tags == null) {
            return false;
        }
        if (this.isTagTrue(tag)) {
            return true;
        }
        String value = this.getTag(tag = tag.toLowerCase());
        return "designated".equals(value) || "official".equals(value) || "permissive".equals(value) || "unknown".equals(value);
    }

    public String getTag(String tag) {
        tag = tag.toLowerCase();
        if (this.tags != null && this.tags.containsKey(tag)) {
            return this.tags.get(tag);
        }
        return null;
    }

    public OptionalInt getTagAsInt(String tag, Consumer<String> errorHandler) {
        String value = this.getTag(tag);
        if (value != null) {
            try {
                return OptionalInt.of(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                errorHandler.accept(value);
            }
        }
        return OptionalInt.empty();
    }

    public Boolean isTag(String tag, String value) {
        tag = tag.toLowerCase();
        if (this.tags != null && this.tags.containsKey(tag) && value != null) {
            return value.equals(this.tags.get(tag));
        }
        return false;
    }

    public I18NString getAssumedName() {
        if (this.tags == null) {
            return null;
        }
        if (this.tags.containsKey("name")) {
            return TranslatedString.getI18NString(TemplateLibrary.generateI18N("{name}", this), true, false);
        }
        if (this.tags.containsKey("otp:route_name")) {
            return new NonLocalizedString(this.tags.get("otp:route_name"));
        }
        if (this.creativeName != null) {
            return this.creativeName;
        }
        if (this.tags.containsKey("otp:route_ref")) {
            return new NonLocalizedString(this.tags.get("otp:route_ref"));
        }
        if (this.tags.containsKey("ref")) {
            return new NonLocalizedString(this.tags.get("ref"));
        }
        return null;
    }

    public Map<String, String> getTagsByPrefix(String prefix) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            String k = entry.getKey();
            if (!k.equals(prefix) && !k.startsWith(prefix + ":")) continue;
            out.put(k, entry.getValue());
        }
        if (out.isEmpty()) {
            return null;
        }
        return out;
    }

    public boolean isUnderConstruction() {
        String highway = this.getTag("highway");
        String cycleway = this.getTag("cycleway");
        return "construction".equals(highway) || "construction".equals(cycleway);
    }

    public boolean isGeneralAccessDenied() {
        return this.isTagDeniedAccess("access");
    }

    public boolean isMotorcarExplicitlyDenied() {
        return this.isTagDeniedAccess("motorcar");
    }

    public boolean isMotorcarExplicitlyAllowed() {
        return this.doesTagAllowAccess("motorcar");
    }

    public boolean isMotorVehicleExplicitlyDenied() {
        return this.isTagDeniedAccess("motor_vehicle");
    }

    public boolean isMotorVehicleExplicitlyAllowed() {
        return this.doesTagAllowAccess("motor_vehicle");
    }

    public boolean isVehicleExplicitlyDenied() {
        return this.isTagDeniedAccess("vehicle");
    }

    public boolean isVehicleExplicitlyAllowed() {
        return this.doesTagAllowAccess("vehicle");
    }

    public boolean isBicycleExplicitlyDenied() {
        return this.isTagDeniedAccess("bicycle") || "dismount".equals(this.getTag("bicycle")) || "use_sidepath".equals(this.getTag("bicycle"));
    }

    public boolean isBicycleExplicitlyAllowed() {
        return this.doesTagAllowAccess("bicycle");
    }

    public boolean isPedestrianExplicitlyDenied() {
        return this.isTagDeniedAccess("foot");
    }

    public boolean isPedestrianExplicitlyAllowed() {
        return this.doesTagAllowAccess("foot");
    }

    public boolean isParkAndRide() {
        String parkingType = this.getTag("parking");
        String parkAndRide = this.getTag("park_ride");
        return this.isTag("amenity", "parking") != false && (parkingType != null && parkingType.contains("park_and_ride") || parkAndRide != null && !parkAndRide.equalsIgnoreCase("no"));
    }

    public boolean isBoardingLocation() {
        return "bus_stop".equals(this.getTag("highway")) || "tram_stop".equals(this.getTag("railway")) || "station".equals(this.getTag("railway")) || "halt".equals(this.getTag("railway")) || "bus_station".equals(this.getTag("amenity")) || this.isPlatform();
    }

    public boolean isPlatform() {
        return "platform".equals(this.getTag("public_transport")) || "platform".equals(this.getTag("railway"));
    }

    public boolean isBikeParking() {
        return this.isTag("amenity", "bicycle_parking") != false && this.isTag("access", "private") == false && this.isTag("access", "no") == false;
    }

    public void setCreativeName(I18NString creativeName) {
        this.creativeName = creativeName;
    }

    public String getOpenStreetMapLink() {
        return null;
    }

    public Set<String> getMultiTagValues(Set<String> refTags) {
        return refTags.stream().map(this::getTag).filter(Objects::nonNull).flatMap(v -> Arrays.stream(v.split(";"))).map(String::strip).filter(v -> !v.isBlank()).collect(Collectors.toSet());
    }

    public OSMProvider getOsmProvider() {
        return this.osmProvider;
    }

    public void setOsmProvider(OSMProvider provider) {
        this.osmProvider = provider;
    }

    private boolean isTagDeniedAccess(String tagName) {
        String tagValue = this.getTag(tagName);
        return "no".equals(tagValue) || "license".equals(tagValue);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("tags", this.tags).toString();
    }
}

