/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.model;

import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public class OSMNode
extends OSMWithTags {
    public double lat;
    public double lon;

    @Override
    public String toString() {
        return "osm node " + this.id;
    }

    public Coordinate getCoordinate() {
        return new Coordinate(this.lon, this.lat);
    }

    public int getCapacity() throws NumberFormatException {
        String capacity = this.getTag("capacity");
        if (capacity == null) {
            return 0;
        }
        return Integer.parseInt(this.getTag("capacity"));
    }

    public boolean isMultiLevel() {
        return this.hasTag("highway") && "elevator".equals(this.getTag("highway"));
    }

    public boolean hasTrafficLight() {
        return this.hasTag("highway") && "traffic_signals".equals(this.getTag("highway"));
    }

    public boolean isBollard() {
        return this.isTag("barrier", "bollard");
    }

    public boolean isBarrier() {
        return this.isBollard() || this.isPedestrianExplicitlyDenied() || this.isBicycleExplicitlyDenied() || this.isMotorcarExplicitlyDenied() || this.isMotorVehicleExplicitlyDenied() || this.isGeneralAccessDenied();
    }

    @Override
    public String getOpenStreetMapLink() {
        return String.format("https://www.openstreetmap.org/node/%d", this.getId());
    }
}

