/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.validation;

import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.netex.index.NetexEntityIndex;
import org.opentripplanner.netex.index.hierarchy.AbstractHierarchicalMap;
import org.opentripplanner.netex.validation.AbstractHMapValidationRule;
import org.opentripplanner.netex.validation.DSJOperatingDayNotFound;
import org.opentripplanner.netex.validation.DSJServiceJourneyNotFound;
import org.opentripplanner.netex.validation.JourneyPatternNotFoundInSJ;
import org.opentripplanner.netex.validation.JourneyPatternSJMismatch;
import org.opentripplanner.netex.validation.PassengerStopAssignmentQuayNotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static final Logger LOG = LoggerFactory.getLogger(Validator.class);
    private final NetexEntityIndex index;
    private final DataImportIssueStore issueStore;

    private Validator(NetexEntityIndex index, DataImportIssueStore issueStore) {
        this.index = index;
        this.issueStore = issueStore;
    }

    public static void validate(NetexEntityIndex index, DataImportIssueStore issueStore) {
        new Validator(index, issueStore).run();
    }

    private void run() {
        this.validate(this.index.quayIdByStopPointRef, new PassengerStopAssignmentQuayNotFound());
        this.validate(this.index.serviceJourneyById, new JourneyPatternNotFoundInSJ());
        this.validate(this.index.serviceJourneyById, new JourneyPatternSJMismatch());
        this.validate(this.index.datedServiceJourneys, new DSJOperatingDayNotFound());
        this.validate(this.index.datedServiceJourneys, new DSJServiceJourneyNotFound());
    }

    private <K, V> void validate(AbstractHierarchicalMap<K, V> map, AbstractHMapValidationRule<K, V> rule) {
        rule.setup(this.index.readOnlyView());
        map.validate(rule, this.issueStore::add);
    }
}

