/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping.support;

import java.util.Collection;
import java.util.Comparator;
import javax.ws.rs.NotSupportedException;
import org.opentripplanner.netex.mapping.support.ValidityHelper;
import org.rutebanken.netex.model.ValidBetween;

class ValidityComparator
implements Comparator<Collection<ValidBetween>> {
    ValidityComparator() {
    }

    @Override
    public int compare(Collection<ValidBetween> v1List, Collection<ValidBetween> v2List) {
        if (v1List.size() > 1 || v2List.size() > 1) {
            throw new NotSupportedException("More than one validity period not supported");
        }
        ValidBetween v1 = v1List.stream().findFirst().orElse(null);
        ValidBetween v2 = v2List.stream().findFirst().orElse(null);
        boolean validNow1 = ValidityHelper.isValidNow(v1);
        boolean validNow2 = ValidityHelper.isValidNow(v2);
        if (validNow1 || validNow2) {
            if (validNow1 && validNow2) {
                return 0;
            }
            return validNow1 ? -1 : 1;
        }
        boolean validFuture1 = ValidityHelper.isValidFuture(v1);
        boolean validFuture2 = ValidityHelper.isValidFuture(v2);
        if (validFuture1 || validFuture2) {
            if (validFuture1 && validFuture2) {
                return v1.getFromDate().compareTo(v2.getFromDate());
            }
            return validFuture1 ? -1 : 1;
        }
        boolean validPast1 = ValidityHelper.isValidPast(v1);
        boolean validPast2 = ValidityHelper.isValidPast(v2);
        if (validPast1 || validPast2) {
            if (validPast1 && validPast2) {
                return v2.getToDate().compareTo(v1.getToDate());
            }
            return validPast1 ? -1 : 1;
        }
        return 0;
    }
}

