/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping.calendar;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.opentripplanner.model.calendar.ServiceCalendar;
import org.opentripplanner.model.calendar.ServiceCalendarDate;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class CalendarServiceBuilder {
    static final FeedScopedId EMPTY_SERVICE_ID = new FeedScopedId("CAL-SERVICE", "EMPTY");
    private final FeedScopedIdFactory scopedIdFactory;
    private final Map<Set<LocalDate>, FeedScopedId> serviceCalendar = new ConcurrentHashMap<Set<LocalDate>, FeedScopedId>();
    private long counter = 0L;

    public CalendarServiceBuilder(FeedScopedIdFactory scopedIdFactory) {
        this.scopedIdFactory = scopedIdFactory;
    }

    @Nullable
    public FeedScopedId registerDatesAndGetServiceId(Set<LocalDate> dates) {
        if (dates.isEmpty()) {
            return EMPTY_SERVICE_ID;
        }
        return this.serviceCalendar.computeIfAbsent(dates, ignore -> this.createServiceId());
    }

    public Collection<ServiceCalendarDate> createServiceCalendar() {
        ArrayList<ServiceCalendarDate> dates = new ArrayList<ServiceCalendarDate>();
        for (Map.Entry<Set<LocalDate>, FeedScopedId> it : this.serviceCalendar.entrySet()) {
            for (LocalDate serviceDate : it.getKey()) {
                dates.add(ServiceCalendarDate.create(it.getValue(), serviceDate));
            }
        }
        return dates;
    }

    public ServiceCalendar createEmptyCalendar() {
        ServiceCalendar emptyCalendar = new ServiceCalendar();
        emptyCalendar.setServiceId(EMPTY_SERVICE_ID);
        emptyCalendar.setPeriod(ServiceDateInterval.unbounded());
        return emptyCalendar;
    }

    FeedScopedId createServiceId() {
        return this.scopedIdFactory.createId(String.format("S%06d", ++this.counter));
    }
}

