/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.math.BigInteger;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.mapping.BookingInfoMapper;
import org.opentripplanner.netex.mapping.MultilingualStringMapper;
import org.opentripplanner.netex.mapping.StopTimesMapperResult;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.util.OTPFeature;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.DestinationDisplay_VersionStructure;
import org.rutebanken.netex.model.FlexibleLine;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.LineRefStructure;
import org.rutebanken.netex.model.MultilingualString;
import org.rutebanken.netex.model.PointInJourneyPatternRefStructure;
import org.rutebanken.netex.model.PointInLinkSequence_VersionedChildStructure;
import org.rutebanken.netex.model.Route;
import org.rutebanken.netex.model.ScheduledStopPointRefStructure;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.StopPointInJourneyPattern;
import org.rutebanken.netex.model.TimetabledPassingTime;
import org.rutebanken.netex.model.VersionOfObjectRefStructure;
import org.rutebanken.netex.model.Via_VersionedChildStructure;
import org.rutebanken.netex.model.Vias_RelStructure;

class StopTimesMapper {
    private static final int DAY_IN_SECONDS = 86400;
    private final DataImportIssueStore issueStore;
    private final FeedScopedIdFactory idFactory;
    private final ReadOnlyHierarchicalMap<String, DestinationDisplay> destinationDisplayById;
    private final EntityById<RegularStop> stopsById;
    private final EntityById<AreaStop> flexibleStopLocationsById;
    private final EntityById<GroupStop> groupStopById;
    private final ReadOnlyHierarchicalMap<String, String> quayIdByStopPointRef;
    private final ReadOnlyHierarchicalMap<String, String> flexibleStopPlaceIdByStopPointRef;
    private final ReadOnlyHierarchicalMap<String, Route> routeByid;
    private final ReadOnlyHierarchicalMapById<FlexibleLine> flexibleLinesById;
    private I18NString currentHeadSign;
    private List<String> currentHeadSignVias;

    StopTimesMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory, EntityById<RegularStop> stopsById, EntityById<AreaStop> areaStopById, EntityById<GroupStop> groupStopById, ReadOnlyHierarchicalMap<String, DestinationDisplay> destinationDisplayById, ReadOnlyHierarchicalMap<String, String> quayIdByStopPointRef, ReadOnlyHierarchicalMap<String, String> flexibleStopPlaceIdByStopPointRef, ReadOnlyHierarchicalMapById<FlexibleLine> flexibleLinesById, ReadOnlyHierarchicalMap<String, Route> routeById) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
        this.destinationDisplayById = destinationDisplayById;
        this.stopsById = stopsById;
        this.flexibleStopLocationsById = areaStopById;
        this.groupStopById = groupStopById;
        this.quayIdByStopPointRef = quayIdByStopPointRef;
        this.flexibleStopPlaceIdByStopPointRef = flexibleStopPlaceIdByStopPointRef;
        this.flexibleLinesById = flexibleLinesById;
        this.routeByid = routeById;
    }

    static int calculateOtpTime(LocalTime time, BigInteger dayOffset) {
        int otpTime = time.toSecondOfDay();
        if (dayOffset != null) {
            otpTime += 86400 * dayOffset.intValue();
        }
        return otpTime;
    }

    @Nullable
    StopTimesMapperResult mapToStopTimes(JourneyPattern journeyPattern, Trip trip, List<TimetabledPassingTime> passingTimes, ServiceJourney serviceJourney) {
        StopTimesMapperResult result = new StopTimesMapperResult();
        ArrayList<String> scheduledStopPointIds = new ArrayList<String>();
        for (int i = 0; i < passingTimes.size(); ++i) {
            TimetabledPassingTime currentPassingTime = passingTimes.get(i);
            String pointInJourneyPattern = ((PointInJourneyPatternRefStructure)currentPassingTime.getPointInJourneyPatternRef().getValue()).getRef();
            StopPointInJourneyPattern stopPoint = StopTimesMapper.findStopPoint(pointInJourneyPattern, journeyPattern);
            StopLocation stop = this.lookUpStopLocation(stopPoint);
            if (stop == null) {
                this.issueStore.add("JourneyPatternStopNotFound", "Stop with id %s not found for StopPoint %s in JourneyPattern %s. Trip %s will not be mapped.", stopPoint != null && stopPoint.getScheduledStopPointRef() != null ? ((ScheduledStopPointRefStructure)stopPoint.getScheduledStopPointRef().getValue()).getRef() : "null", stopPoint != null ? stopPoint.getId() : "null", journeyPattern.getId(), trip.getId());
                return null;
            }
            scheduledStopPointIds.add(((ScheduledStopPointRefStructure)stopPoint.getScheduledStopPointRef().getValue()).getRef());
            StopTime stopTime = this.mapToStopTime(trip, stopPoint, stop, currentPassingTime, i);
            if (stopTime == null) {
                return null;
            }
            BookingInfo bookingInfo = new BookingInfoMapper(this.issueStore).map(stopPoint, serviceJourney, this.lookUpFlexibleLine(serviceJourney, journeyPattern));
            stopTime.setDropOffBookingInfo(bookingInfo);
            stopTime.setPickupBookingInfo(bookingInfo);
            result.addStopTime(currentPassingTime.getId(), stopTime);
        }
        result.setScheduledStopPointIds(scheduledStopPointIds);
        if (OTPFeature.FlexRouting.isOn()) {
            StopTimesMapper.modifyDataForUnscheduledFlexTrip(result);
        }
        return result;
    }

    @Nullable
    String findTripHeadsign(JourneyPattern journeyPattern, TimetabledPassingTime firstPassingTime) {
        String pointInJourneyPattern = ((PointInJourneyPatternRefStructure)firstPassingTime.getPointInJourneyPatternRef().getValue()).getRef();
        StopPointInJourneyPattern stopPoint = StopTimesMapper.findStopPoint(pointInJourneyPattern, journeyPattern);
        if (stopPoint == null) {
            return null;
        }
        if (stopPoint.getDestinationDisplayRef() == null) {
            return null;
        }
        DestinationDisplay destinationDisplay = this.destinationDisplayById.lookup(stopPoint.getDestinationDisplayRef().getRef());
        return destinationDisplay == null ? null : MultilingualStringMapper.nullableValueOf(destinationDisplay.getFrontText());
    }

    @Nullable
    private static StopPointInJourneyPattern findStopPoint(String pointInJourneyPatterRef, JourneyPattern journeyPattern) {
        List points = journeyPattern.getPointsInSequence().getPointInJourneyPatternOrStopPointInJourneyPatternOrTimingPointInJourneyPattern();
        for (PointInLinkSequence_VersionedChildStructure point : points) {
            StopPointInJourneyPattern stopPoint;
            if (!(point instanceof StopPointInJourneyPattern) || !(stopPoint = (StopPointInJourneyPattern)point).getId().equals(pointInJourneyPatterRef)) continue;
            return stopPoint;
        }
        return null;
    }

    private static int calculateOtpTime(LocalTime time, BigInteger dayOffset, LocalTime fallbackTime, BigInteger fallbackDayOffset) {
        return time != null ? StopTimesMapper.calculateOtpTime(time, dayOffset) : StopTimesMapper.calculateOtpTime(fallbackTime, fallbackDayOffset);
    }

    private static boolean isFalse(Boolean value) {
        return value != null && value == false;
    }

    private static void modifyDataForUnscheduledFlexTrip(StopTimesMapperResult result) {
        List<StopTime> stopTimes = result.stopTimes;
        if (stopTimes.size() == 2 && stopTimes.stream().allMatch(s -> s.getStop() instanceof AreaStop || s.getStop() instanceof GroupStop)) {
            int departureTime = stopTimes.get(0).getDepartureTime();
            int arrivalTime = stopTimes.get(1).getArrivalTime();
            for (StopTime stopTime : stopTimes) {
                if (stopTime.getFlexWindowStart() == -999) {
                    stopTime.clearDepartureTime();
                    stopTime.setFlexWindowStart(departureTime);
                }
                if (stopTime.getFlexWindowEnd() != -999) continue;
                stopTime.clearArrivalTime();
                stopTime.setFlexWindowEnd(arrivalTime);
            }
        }
    }

    private StopTime mapToStopTime(Trip trip, StopPointInJourneyPattern stopPoint, StopLocation stop, TimetabledPassingTime passingTime, int stopSequence) {
        StopTime stopTime = new StopTime();
        stopTime.setTrip(trip);
        stopTime.setStopSequence(stopSequence);
        stopTime.setStop(stop);
        if (passingTime.getArrivalTime() != null || passingTime.getDepartureTime() != null) {
            stopTime.setArrivalTime(StopTimesMapper.calculateOtpTime(passingTime.getArrivalTime(), passingTime.getArrivalDayOffset(), passingTime.getDepartureTime(), passingTime.getDepartureDayOffset()));
            stopTime.setDepartureTime(StopTimesMapper.calculateOtpTime(passingTime.getDepartureTime(), passingTime.getDepartureDayOffset(), passingTime.getArrivalTime(), passingTime.getArrivalDayOffset()));
            if (Boolean.TRUE.equals(stopPoint.isIsWaitPoint()) && passingTime.getWaitingTime() != null) {
                stopTime.setTimepoint(1);
            }
        } else if (passingTime.getEarliestDepartureTime() != null && passingTime.getLatestArrivalTime() != null) {
            stopTime.setFlexWindowStart(StopTimesMapper.calculateOtpTime(passingTime.getEarliestDepartureTime(), passingTime.getEarliestDepartureDayOffset()));
            stopTime.setFlexWindowEnd(StopTimesMapper.calculateOtpTime(passingTime.getLatestArrivalTime(), passingTime.getLatestArrivalDayOffset()));
        } else {
            return null;
        }
        Object vias = null;
        if (stopPoint != null) {
            DestinationDisplay destinationDisplay;
            if (StopTimesMapper.isFalse(stopPoint.isForAlighting())) {
                stopTime.setDropOffType(PickDrop.NONE);
            } else if (Boolean.TRUE.equals(stopPoint.isRequestStop())) {
                stopTime.setDropOffType(PickDrop.COORDINATE_WITH_DRIVER);
            } else {
                stopTime.setDropOffType(PickDrop.SCHEDULED);
            }
            if (StopTimesMapper.isFalse(stopPoint.isForBoarding())) {
                stopTime.setPickupType(PickDrop.NONE);
            } else if (Boolean.TRUE.equals(stopPoint.isRequestStop())) {
                stopTime.setPickupType(PickDrop.COORDINATE_WITH_DRIVER);
            } else {
                stopTime.setPickupType(PickDrop.SCHEDULED);
            }
            if (stopPoint.getDestinationDisplayRef() != null && (destinationDisplay = this.destinationDisplayById.lookup(stopPoint.getDestinationDisplayRef().getRef())) != null) {
                this.currentHeadSign = new NonLocalizedString(destinationDisplay.getFrontText().getValue());
                Vias_RelStructure viaValues = destinationDisplay.getVias();
                if (viaValues != null && viaValues.getVia() != null) {
                    this.currentHeadSignVias = viaValues.getVia().stream().map(Via_VersionedChildStructure::getDestinationDisplayRef).filter(Objects::nonNull).map(VersionOfObjectRefStructure::getRef).filter(Objects::nonNull).map(this.destinationDisplayById::lookup).filter(Objects::nonNull).map(DestinationDisplay_VersionStructure::getFrontText).filter(Objects::nonNull).map(MultilingualString::getValue).filter(Objects::nonNull).collect(Collectors.toList());
                    if (this.currentHeadSignVias.isEmpty()) {
                        this.currentHeadSignVias = null;
                    }
                } else {
                    this.currentHeadSignVias = null;
                }
            }
        }
        if (passingTime.getArrivalTime() == null && passingTime.getDepartureTime() == null && passingTime.getEarliestDepartureTime() == null && passingTime.getLatestArrivalTime() == null) {
            this.issueStore.add("TripWithoutTime", "Time missing for trip %s", trip.getId());
        }
        if (this.currentHeadSign != null) {
            stopTime.setStopHeadsign(this.currentHeadSign);
        }
        if (this.currentHeadSignVias != null) {
            stopTime.setHeadsignVias(this.currentHeadSignVias);
        }
        return stopTime;
    }

    @Nullable
    private StopLocation lookUpStopLocation(StopPointInJourneyPattern stopPointInJourneyPattern) {
        StopLocation stopLocation;
        if (stopPointInJourneyPattern == null) {
            return null;
        }
        String stopPointRef = ((ScheduledStopPointRefStructure)stopPointInJourneyPattern.getScheduledStopPointRef().getValue()).getRef();
        String stopId = this.quayIdByStopPointRef.lookup(stopPointRef);
        String flexibleStopPlaceId = this.flexibleStopPlaceIdByStopPointRef.lookup(stopPointRef);
        if (stopId == null && flexibleStopPlaceId == null) {
            this.issueStore.add("PassengerStopAssignmentNotFound", "No passengerStopAssignment found for %s", stopPointRef);
            return null;
        }
        if (stopId != null) {
            stopLocation = this.stopsById.get(this.idFactory.createId(stopId));
        } else {
            AreaStop areaStop = this.flexibleStopLocationsById.get(this.idFactory.createId(flexibleStopPlaceId));
            GroupStop groupStop = this.groupStopById.get(this.idFactory.createId(flexibleStopPlaceId));
            stopLocation = areaStop != null ? areaStop : groupStop;
        }
        if (stopLocation == null) {
            this.issueStore.add("StopPointInJourneyPatternMissingStopLocation", "No Quay or FlexibleStopPlace found for %s", stopPointRef);
        }
        return stopLocation;
    }

    private FlexibleLine lookUpFlexibleLine(ServiceJourney serviceJourney, JourneyPattern journeyPattern) {
        if (serviceJourney == null) {
            return null;
        }
        String lineRef = null;
        JAXBElement lineRefStruct = serviceJourney.getLineRef();
        if (lineRefStruct != null) {
            lineRef = ((LineRefStructure)lineRefStruct.getValue()).getRef();
        } else if (serviceJourney.getJourneyPatternRef() != null) {
            String routeRef = journeyPattern.getRouteRef().getRef();
            lineRef = ((LineRefStructure)this.routeByid.lookup(routeRef).getLineRef().getValue()).getRef();
        }
        return (FlexibleLine)this.flexibleLinesById.lookup(lineRef);
    }
}

