/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.common.model.T2;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.rutebanken.netex.model.StopPlace;

class StopPlaceTypeMapper {
    StopPlaceTypeMapper() {
    }

    public T2<TransitMode, String> map(StopPlace stopPlace) {
        T2<TransitMode, String> submode = this.getSubmodeAsString(stopPlace);
        if (submode != null) {
            return submode;
        }
        TransitMode mode = this.mapVehicleMode(stopPlace);
        return new T2<TransitMode, Object>(mode, null);
    }

    private TransitMode mapVehicleMode(StopPlace stopPlace) {
        if (stopPlace.getTransportMode() == null) {
            return null;
        }
        switch (stopPlace.getTransportMode()) {
            case AIR: {
                return TransitMode.AIRPLANE;
            }
            case BUS: {
                return TransitMode.BUS;
            }
            case TROLLEY_BUS: {
                return TransitMode.TROLLEYBUS;
            }
            case CABLEWAY: {
                return TransitMode.CABLE_CAR;
            }
            case COACH: {
                return TransitMode.COACH;
            }
            case FUNICULAR: {
                return TransitMode.FUNICULAR;
            }
            case METRO: {
                return TransitMode.SUBWAY;
            }
            case RAIL: {
                return TransitMode.RAIL;
            }
            case TRAM: {
                return TransitMode.TRAM;
            }
            case WATER: 
            case FERRY: {
                return TransitMode.FERRY;
            }
        }
        return null;
    }

    private T2<TransitMode, String> getSubmodeAsString(StopPlace stopPlace) {
        if (stopPlace.getAirSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.AIRPLANE, stopPlace.getAirSubmode().value());
        }
        if (stopPlace.getBusSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.BUS, stopPlace.getBusSubmode().value());
        }
        if (stopPlace.getTelecabinSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.GONDOLA, stopPlace.getTelecabinSubmode().value());
        }
        if (stopPlace.getCoachSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.COACH, stopPlace.getCoachSubmode().value());
        }
        if (stopPlace.getFunicularSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.FUNICULAR, stopPlace.getFunicularSubmode().value());
        }
        if (stopPlace.getMetroSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.SUBWAY, stopPlace.getMetroSubmode().value());
        }
        if (stopPlace.getRailSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.RAIL, stopPlace.getRailSubmode().value());
        }
        if (stopPlace.getTramSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.TRAM, stopPlace.getTramSubmode().value());
        }
        if (stopPlace.getWaterSubmode() != null) {
            return new T2<TransitMode, String>(TransitMode.FERRY, stopPlace.getWaterSubmode().value());
        }
        return null;
    }
}

