/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBElement;
import net.opengis.gml._3.LineStringType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.MissingProjectionInServiceLink;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.LinkInLinkSequence_VersionedChildStructure;
import org.rutebanken.netex.model.LinkSequenceProjection_VersionStructure;
import org.rutebanken.netex.model.ServiceLink;
import org.rutebanken.netex.model.ServiceLinkInJourneyPattern_VersionedChildStructure;

class ServiceLinkMapper {
    private static final GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
    private final FeedScopedIdFactory idFactory;
    private final ReadOnlyHierarchicalMapById<ServiceLink> serviceLinkById;
    private final ReadOnlyHierarchicalMap<String, String> quayIdByStopPointRef;
    private final EntityById<RegularStop> stopById;
    private final DataImportIssueStore issueStore;
    private final double maxStopToShapeSnapDistance;

    ServiceLinkMapper(FeedScopedIdFactory idFactory, ReadOnlyHierarchicalMapById<ServiceLink> serviceLinkById, ReadOnlyHierarchicalMap<String, String> quayIdByStopPointRef, EntityById<RegularStop> stopById, DataImportIssueStore issueStore, double maxStopToShapeSnapDistance) {
        this.idFactory = idFactory;
        this.serviceLinkById = serviceLinkById;
        this.quayIdByStopPointRef = quayIdByStopPointRef;
        this.stopById = stopById;
        this.issueStore = issueStore;
        this.maxStopToShapeSnapDistance = maxStopToShapeSnapDistance;
    }

    List<LineString> getGeometriesByJourneyPattern(JourneyPattern journeyPattern, StopPattern stopPattern) {
        LineString[] geometries = new LineString[stopPattern.getSize() - 1];
        if (journeyPattern.getLinksInSequence() != null) {
            List linksInJourneyPattern = journeyPattern.getLinksInSequence().getServiceLinkInJourneyPatternOrTimingLinkInJourneyPattern();
            for (int i = 0; i < linksInJourneyPattern.size(); ++i) {
                LinkInLinkSequence_VersionedChildStructure linkInLinkSequence = (LinkInLinkSequence_VersionedChildStructure)linksInJourneyPattern.get(i);
                if (!(linkInLinkSequence instanceof ServiceLinkInJourneyPattern_VersionedChildStructure)) continue;
                ServiceLinkInJourneyPattern_VersionedChildStructure serviceLinkInJourneyPattern = (ServiceLinkInJourneyPattern_VersionedChildStructure)linkInLinkSequence;
                String serviceLinkRef = serviceLinkInJourneyPattern.getServiceLinkRef().getRef();
                ServiceLink serviceLink = (ServiceLink)this.serviceLinkById.lookup(serviceLinkRef);
                if (serviceLink != null) {
                    geometries[i] = this.mapServiceLink(serviceLink, stopPattern, i);
                    continue;
                }
                this.issueStore.add("MissingServiceLink", "ServiceLink %s not found in journey pattern %s", serviceLinkRef, journeyPattern.getId());
            }
        }
        for (int i = 0; i < stopPattern.getSize() - 1; ++i) {
            if (geometries[i] != null) continue;
            geometries[i] = this.createSimpleGeometry(stopPattern.getStop(i), stopPattern.getStop(i + 1));
        }
        return Arrays.asList(geometries);
    }

    private LineString mapServiceLink(ServiceLink serviceLink, StopPattern stopPattern, int stopIndex) {
        if (serviceLink.getProjections() == null || serviceLink.getProjections().getProjectionRefOrProjection() == null) {
            this.issueStore.add(new MissingProjectionInServiceLink(serviceLink.getId()));
            return null;
        }
        if (!this.isFromToPointRefsValid(serviceLink, stopPattern, stopIndex)) {
            return null;
        }
        for (JAXBElement projectionElement : serviceLink.getProjections().getProjectionRefOrProjection()) {
            Object projectionObj = projectionElement.getValue();
            if (!(projectionObj instanceof LinkSequenceProjection_VersionStructure)) continue;
            LinkSequenceProjection_VersionStructure linkSequenceProjection = (LinkSequenceProjection_VersionStructure)projectionObj;
            LineStringType lineString = linkSequenceProjection.getLineString();
            if (!this.isProjectionValid(lineString, serviceLink.getId())) {
                return null;
            }
            List positionList = lineString.getPosList().getValue();
            Coordinate[] coordinates = new Coordinate[positionList.size() / 2];
            for (int i = 0; i < positionList.size(); i += 2) {
                coordinates[i / 2] = new Coordinate(((Double)positionList.get(i + 1)).doubleValue(), ((Double)positionList.get(i)).doubleValue());
            }
            LineString geometry = geometryFactory.createLineString(coordinates);
            if (!this.isGeometryValid((Geometry)geometry, serviceLink.getId()) || !this.areEndpointsWithinTolerance((Geometry)geometry, stopPattern.getStop(stopIndex), stopPattern.getStop(stopIndex + 1), serviceLink.getId())) {
                return null;
            }
            return geometry;
        }
        this.issueStore.add("ServiceLinkWithoutProjection", "Ignore ServiceLink without projection: %s", serviceLink.getId());
        return null;
    }

    private LineString createSimpleGeometry(StopLocation s0, StopLocation s1) {
        Coordinate[] coordinates = new Coordinate[]{s0.getCoordinate().asJtsCoordinate(), s1.getCoordinate().asJtsCoordinate()};
        PackedCoordinateSequence.Double sequence = new PackedCoordinateSequence.Double(coordinates, 2);
        return geometryFactory.createLineString((CoordinateSequence)sequence);
    }

    private boolean isFromToPointRefsValid(ServiceLink serviceLink, StopPattern stopPattern, int stopIndex) {
        String fromPointQuayId = this.quayIdByStopPointRef.lookup(serviceLink.getFromPointRef().getRef());
        RegularStop fromPointStop = this.stopById.get(this.idFactory.createId(fromPointQuayId));
        String toPointQuayId = this.quayIdByStopPointRef.lookup(serviceLink.getToPointRef().getRef());
        RegularStop toPointStop = this.stopById.get(this.idFactory.createId(toPointQuayId));
        if (fromPointStop == null || toPointStop == null) {
            this.issueStore.add("ServiceLinkWithoutQuay", "Service link with missing or unknown quays. Link: %s", serviceLink);
            return false;
        }
        if (!fromPointStop.equals(stopPattern.getStop(stopIndex))) {
            this.issueStore.add("ServiceLinkQuayMismatch", "Service link %s with quays different from point in journey pattern. Link point: %s, journey pattern point: %s", serviceLink, stopPattern.getStop(stopIndex).getId().getId(), fromPointQuayId);
            return false;
        }
        if (!toPointStop.equals(stopPattern.getStop(stopIndex + 1))) {
            this.issueStore.add("ServiceLinkQuayMismatch", "Service link %s with quays different to point in journey pattern. Link point: %s, journey pattern point: %s", serviceLink, stopPattern.getStop(stopIndex).getId().getId(), toPointQuayId);
            return false;
        }
        return true;
    }

    private boolean isProjectionValid(LineStringType lineString, String id) {
        if (lineString == null) {
            this.issueStore.add("ServiceLinkWithoutLineString", "Ignore linkSequenceProjection without linestring for: %s", id);
            return false;
        }
        List coordinates = lineString.getPosList().getValue();
        if (coordinates.size() < 4) {
            this.issueStore.add("ServiceLinkGeometryError", "Ignore linkSequenceProjection with invalid linestring, containing fewer than two coordinates for: %s", id);
            return false;
        }
        if (coordinates.size() % 2 != 0) {
            this.issueStore.add("ServiceLinkGeometryError", "Ignore linkSequenceProjection with invalid linestring, containing odd number of values for coordinates: %s", id);
            return false;
        }
        return true;
    }

    private boolean isGeometryValid(Geometry geometry, String id) {
        Coordinate[] coordinates = geometry.getCoordinates();
        if (coordinates.length < 2) {
            this.issueStore.add("ServiceLinkGeometryError", "Ignore linkSequenceProjection with invalid linestring, containing fewer than two coordinates for: %s", id);
            return false;
        }
        if (geometry.getLength() == 0.0) {
            this.issueStore.add("ServiceLinkGeometryError", "Ignore linkSequenceProjection with invalid linestring, having distance of 0 for: %s", id);
            return false;
        }
        for (Coordinate coordinate : coordinates) {
            if (!Double.isNaN(coordinate.x) && !Double.isNaN(coordinate.y)) continue;
            this.issueStore.add("ServiceLinkGeometryError", "Ignore linkSequenceProjection with invalid linestring, containing coordinate with NaN for: %s", id);
            return false;
        }
        return true;
    }

    private boolean areEndpointsWithinTolerance(Geometry geometry, StopLocation fromStop, StopLocation toStop, String id) {
        Coordinate[] coordinates = geometry.getCoordinates();
        Coordinate geometryStartCoordinate = coordinates[0];
        Coordinate geometryEndCoordinate = coordinates[coordinates.length - 1];
        Coordinate startCoordinate = fromStop.getCoordinate().asJtsCoordinate();
        Coordinate endCoordinate = toStop.getCoordinate().asJtsCoordinate();
        if (SphericalDistanceLibrary.fastDistance(startCoordinate, geometryStartCoordinate) > this.maxStopToShapeSnapDistance) {
            this.issueStore.add("ServiceLinkGeometryTooFar", "Ignore linkSequenceProjection with too long distance between stop and start of linestring,  stop %s, distance: %s, link id: %s", fromStop, SphericalDistanceLibrary.fastDistance(startCoordinate, geometryStartCoordinate), id);
            return false;
        }
        if (SphericalDistanceLibrary.fastDistance(endCoordinate, geometryEndCoordinate) > this.maxStopToShapeSnapDistance) {
            this.issueStore.add("ServiceLinkGeometryTooFar", "Ignore linkSequenceProjection with too long distance between stop and end of linestring,  stop %s, distance: %s, link id: %s", toStop, SphericalDistanceLibrary.fastDistance(endCoordinate, geometryEndCoordinate), id);
            return false;
        }
        return true;
    }
}

