/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.organization.OperatorBuilder;
import org.rutebanken.netex.model.ContactStructure;

class OperatorToAgencyMapper {
    private final FeedScopedIdFactory idFactory;

    OperatorToAgencyMapper(FeedScopedIdFactory idFactory) {
        this.idFactory = idFactory;
    }

    Operator mapOperator(org.rutebanken.netex.model.Operator source) {
        OperatorBuilder target = Operator.of(this.idFactory.createId(source.getId())).withName(source.getName().getValue());
        OperatorToAgencyMapper.mapContactDetails(source.getContactDetails(), target);
        return (Operator)target.build();
    }

    private static void mapContactDetails(ContactStructure contactDetails, OperatorBuilder target) {
        if (contactDetails == null) {
            return;
        }
        target.withUrl(contactDetails.getUrl());
        target.withPhone(contactDetails.getPhone());
    }
}

