/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.netex.mapping.support.NetexObjectDecorator;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.AgencyBuilder;
import org.rutebanken.netex.model.Authority;

class AuthorityToAgencyMapper {
    private final FeedScopedIdFactory idFactory;
    private final String timeZone;
    private final String dummyAgencyId;

    AuthorityToAgencyMapper(FeedScopedIdFactory idFactory, String timeZone) {
        this.idFactory = idFactory;
        this.timeZone = timeZone;
        this.dummyAgencyId = "Dummy-" + timeZone;
    }

    Agency mapAuthorityToAgency(Authority source) {
        AgencyBuilder target = Agency.of(this.idFactory.createId(source.getId())).withName(source.getName().getValue()).withTimezone(this.timeZone);
        NetexObjectDecorator.withOptional(source.getContactDetails(), c -> {
            target.withUrl(c.getUrl());
            target.withPhone(c.getPhone());
        });
        return (Agency)target.build();
    }

    Agency createDummyAgency() {
        return (Agency)Agency.of(this.idFactory.createId(this.dummyAgencyId)).withName("N/A").withTimezone(this.timeZone).withUrl("N/A").withPhone("N/A").build();
    }

    String dummyAgencyId() {
        return this.dummyAgencyId;
    }
}

