/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.loader.parser;

import java.util.Collection;
import org.opentripplanner.netex.index.NetexEntityIndex;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;

abstract class NetexParser<T> {
    NetexParser() {
    }

    static void verifyCommonUnusedPropertiesIsNotSet(Logger log, VersionFrame_VersionStructure rel) {
        NetexParser.warnOnMissingMapping(log, rel.getTypeOfFrameRef());
        NetexParser.warnOnMissingMapping(log, rel.getBaselineVersionFrameRef());
        NetexParser.warnOnMissingMapping(log, rel.getCodespaces());
        NetexParser.warnOnMissingMapping(log, rel.getFrameDefaults());
        NetexParser.warnOnMissingMapping(log, rel.getVersions());
        NetexParser.warnOnMissingMapping(log, rel.getTraces());
        NetexParser.warnOnMissingMapping(log, rel.getContentValidityConditions());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getKeyList());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getExtensions());
        NetexParser.warnOnMissingMapping(log, rel.getBrandingRef());
    }

    static void warnOnMissingMapping(Logger log, Object rel) {
        if (rel == null) {
            return;
        }
        if (rel instanceof Collection) {
            throw new IllegalArgumentException("Do not pass in collections to this method.");
        }
        log.warn("Netex import - Element mapping is missing for {}.", (Object)rel.getClass().getName());
    }

    static void informOnElementIntentionallySkipped(Logger log, Object rel) {
        if (rel == null) {
            return;
        }
        if (rel instanceof Collection) {
            throw new IllegalArgumentException("Do not pass in collections to this method.");
        }
        log.info("Netex import - Element skipped: {}", (Object)rel.getClass().getName());
    }

    abstract void parse(T var1);

    abstract void setResultOnIndex(NetexEntityIndex var1);
}

