/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.transfer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.model.transfer.RouteStationTransferPoint;
import org.opentripplanner.model.transfer.RouteStopTransferPoint;
import org.opentripplanner.model.transfer.StationTransferPoint;
import org.opentripplanner.model.transfer.StopTransferPoint;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;

class TransferPointMap<E> {
    private final Map<T2<Trip, Integer>, E> tripMap = new HashMap<T2<Trip, Integer>, E>();
    private final Map<T2<Route, StopLocation>, E> routeStopMap = new HashMap<T2<Route, StopLocation>, E>();
    private final Map<T2<Route, Station>, E> routeStationMap = new HashMap<T2<Route, Station>, E>();
    private final Map<StopLocation, E> stopMap = new HashMap<StopLocation, E>();
    private final Map<Station, E> stationMap = new HashMap<Station, E>();

    TransferPointMap() {
    }

    void put(TransferPoint point, E e) {
        if (point.isTripTransferPoint()) {
            TripTransferPoint tp = point.asTripTransferPoint();
            this.tripMap.put(TransferPointMap.tripKey(tp.getTrip(), tp.getStopPositionInPattern()), e);
        } else if (point.isRouteStopTransferPoint()) {
            RouteStopTransferPoint rp = point.asRouteStopTransferPoint();
            this.routeStopMap.put(TransferPointMap.routeStopKey(rp.getRoute(), rp.getStop()), e);
        } else if (point.isRouteStationTransferPoint()) {
            RouteStationTransferPoint rp = point.asRouteStationTransferPoint();
            this.routeStationMap.put(TransferPointMap.routeStationKey(rp.getRoute(), rp.getStation()), e);
        } else if (point.isStopTransferPoint()) {
            this.stopMap.put(point.asStopTransferPoint().getStop(), e);
        } else if (point.isStationTransferPoint()) {
            this.stationMap.put(point.asStationTransferPoint().getStation(), e);
        } else {
            throw new IllegalArgumentException("Unknown TransferPoint type: " + point);
        }
    }

    E computeIfAbsent(TransferPoint point, Supplier<E> creator) {
        if (point.isTripTransferPoint()) {
            TripTransferPoint tp = point.asTripTransferPoint();
            return (E)this.tripMap.computeIfAbsent(TransferPointMap.tripKey(tp.getTrip(), tp.getStopPositionInPattern()), (? super K k) -> creator.get());
        }
        if (point.isRouteStopTransferPoint()) {
            RouteStopTransferPoint rp = point.asRouteStopTransferPoint();
            return (E)this.routeStopMap.computeIfAbsent(TransferPointMap.routeStopKey(rp.getRoute(), rp.getStop()), (? super K k) -> creator.get());
        }
        if (point.isRouteStationTransferPoint()) {
            RouteStationTransferPoint rp = point.asRouteStationTransferPoint();
            return (E)this.routeStationMap.computeIfAbsent(TransferPointMap.routeStationKey(rp.getRoute(), rp.getStation()), (? super K k) -> creator.get());
        }
        if (point.isStopTransferPoint()) {
            StopTransferPoint sp = point.asStopTransferPoint();
            return (E)this.stopMap.computeIfAbsent(sp.getStop(), (? super K k) -> creator.get());
        }
        if (point.isStationTransferPoint()) {
            StationTransferPoint sp = point.asStationTransferPoint();
            return (E)this.stationMap.computeIfAbsent(sp.getStation(), (? super K k) -> creator.get());
        }
        throw new IllegalArgumentException("Unknown TransferPoint type: " + point);
    }

    List<E> get(Trip trip, StopLocation stop, int stopPointInPattern) {
        return Stream.of(this.tripMap.get(TransferPointMap.tripKey(trip, stopPointInPattern)), this.routeStopMap.get(TransferPointMap.routeStopKey(trip.getRoute(), stop)), this.routeStationMap.get(TransferPointMap.routeStationKey(trip.getRoute(), stop.getParentStation())), this.stopMap.get(stop), this.stationMap.get(stop.getParentStation())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static T2<Trip, Integer> tripKey(Trip trip, int stopPositionInPattern) {
        return new T2<Trip, Integer>(trip, stopPositionInPattern);
    }

    private static T2<Route, StopLocation> routeStopKey(Route route, StopLocation stop) {
        return new T2<Route, StopLocation>(route, stop);
    }

    private static T2<Route, Station> routeStationKey(Route route, Station station) {
        return new T2<Route, Station>(route, station);
    }
}

