/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.projectinfo;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.util.OtpAppException;

public class GraphFileHeader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAGIC_NUMBER = "OpenTripPlannerGraph";
    private static final char ID_PREFIX = '0';
    private static final char DELIMITER = ';';
    private static final int ID_LENGTH = 7;
    private static final int HEADER_LENGTH = "OpenTripPlannerGraph".length() + 7 + 2;
    private static final Pattern HEADER_PATTERN = Pattern.compile("OpenTripPlannerGraph;([-\\w.:+/]{7});");
    public static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    public static final String UNKNOWN_ID = "UNKNOWN";
    private final String otpSerializationVersionId;
    private final byte[] bytes;

    GraphFileHeader() {
        this(UNKNOWN_ID);
    }

    GraphFileHeader(String otpSerializationVersionId) {
        this.otpSerializationVersionId = GraphFileHeader.stripId(otpSerializationVersionId);
        this.bytes = this.asString().getBytes(CHARSET);
    }

    public static int headerLength() {
        return HEADER_LENGTH;
    }

    public static GraphFileHeader parse(byte[] buf) {
        if (buf.length < HEADER_LENGTH) {
            throw new OtpAppException("Input file header is not large enough. At least " + HEADER_LENGTH + " bytes is needed. Input: " + GraphFileHeader.prettyBytesToString(buf));
        }
        String header = new String(buf, 0, HEADER_LENGTH, CHARSET);
        Matcher m = HEADER_PATTERN.matcher(header);
        if (!m.matches()) {
            throw new OtpAppException("The file is no recognized as an OTP Graph file. The header do not match \"" + HEADER_PATTERN.pattern() + "\".\n\tInput: " + GraphFileHeader.prettyBytesToString(buf));
        }
        return new GraphFileHeader(m.group(1));
    }

    public byte[] header() {
        return this.bytes;
    }

    public String magicNumber() {
        return MAGIC_NUMBER;
    }

    public String otpSerializationVersionId() {
        return this.otpSerializationVersionId;
    }

    public String otpSerializationVersionIdPadded() {
        return GraphFileHeader.padId(this.otpSerializationVersionId);
    }

    public String asString() {
        return "OpenTripPlannerGraph;" + this.otpSerializationVersionIdPadded() + ";";
    }

    public boolean isUnknown() {
        return UNKNOWN_ID.equals(this.otpSerializationVersionId);
    }

    public int hashCode() {
        return this.otpSerializationVersionId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphFileHeader that = (GraphFileHeader)o;
        return this.otpSerializationVersionId.equals(that.otpSerializationVersionId);
    }

    public String toString() {
        return this.asString();
    }

    static String padId(String text) {
        StringBuilder buf = new StringBuilder();
        while (buf.length() + text.length() < 7) {
            buf.append('0');
        }
        buf.append(text);
        return buf.toString();
    }

    static String stripId(String text) {
        int pos;
        for (pos = 0; pos < text.length() && text.charAt(pos) == '0'; ++pos) {
        }
        return text.substring(pos);
    }

    static String prettyBytesToString(byte[] text) {
        if (text == null || text.length == 0) {
            return "[empty]";
        }
        StringBuilder buf = new StringBuilder();
        for (byte v : text) {
            buf.append(" ").append(String.format("%02X", v));
        }
        return buf.substring(1) + "  \"" + new String(text, CHARSET) + "\"";
    }
}

