/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.pagecursor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import javax.annotation.Nullable;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.pagecursor.PageCursor;
import org.opentripplanner.model.plan.pagecursor.PageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PageCursorSerializer {
    private static final int NOT_SET = Integer.MIN_VALUE;
    private static final byte VERSION = 1;
    private static final long TIME_ZERO = ZonedDateTime.of(2020, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC")).toEpochSecond();
    private static final Logger LOG = LoggerFactory.getLogger(PageCursor.class);

    private PageCursorSerializer() {
    }

    @Nullable
    public static String encode(PageCursor cursor) {
        String string;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        try {
            PageCursorSerializer.writeByte((byte)1, out);
            PageCursorSerializer.writeEnum(cursor.type, out);
            PageCursorSerializer.writeTime(cursor.earliestDepartureTime, out);
            PageCursorSerializer.writeTime(cursor.latestArrivalTime, out);
            PageCursorSerializer.writeDuration(cursor.searchWindow, out);
            PageCursorSerializer.writeEnum(cursor.originalSortOrder, out);
            out.flush();
            string = Base64.getUrlEncoder().encodeToString(buf.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Failed to encode page cursor", (Throwable)e);
                return null;
            }
        }
        out.close();
        return string;
    }

    @Nullable
    public static PageCursor decode(String cursor) {
        PageCursor pageCursor;
        if (cursor == null || cursor.isBlank()) {
            return null;
        }
        byte[] buf = Base64.getUrlDecoder().decode(cursor);
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        ObjectInputStream in = new ObjectInputStream(input);
        try {
            byte version = PageCursorSerializer.readByte(in);
            PageType type = PageCursorSerializer.readEnum(in, PageType.class);
            Instant edt = PageCursorSerializer.readTime(in);
            Instant lat = PageCursorSerializer.readTime(in);
            Duration searchWindow = PageCursorSerializer.readDuration(in);
            SortOrder originalSortOrder = PageCursorSerializer.readEnum(in, SortOrder.class);
            pageCursor = new PageCursor(type, originalSortOrder, edt, lat, searchWindow);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Unable to decode page cursor: '" + cursor + "'", (Throwable)e);
                return null;
            }
        }
        in.close();
        return pageCursor;
    }

    private static void writeByte(byte value, ObjectOutputStream out) throws IOException {
        out.writeByte(value);
    }

    private static byte readByte(ObjectInputStream in) throws IOException {
        return in.readByte();
    }

    private static void writeTime(Instant time, ObjectOutputStream out) throws IOException {
        out.writeInt(time == null ? Integer.MIN_VALUE : (int)(time.getEpochSecond() - TIME_ZERO));
    }

    @Nullable
    private static Instant readTime(ObjectInputStream in) throws IOException {
        int value = in.readInt();
        return value == Integer.MIN_VALUE ? null : Instant.ofEpochSecond(TIME_ZERO + (long)value);
    }

    private static void writeDuration(Duration duration, ObjectOutputStream out) throws IOException {
        out.writeInt((int)duration.toSeconds());
    }

    private static Duration readDuration(ObjectInputStream in) throws IOException {
        return Duration.ofSeconds(in.readInt());
    }

    private static void writeBoolean(boolean value, ObjectOutputStream out) throws IOException {
        out.writeBoolean(value);
    }

    private static boolean readBoolean(ObjectInputStream in) throws IOException {
        return in.readBoolean();
    }

    private static <T extends Enum<T>> void writeEnum(T value, ObjectOutputStream out) throws IOException {
        out.writeUTF(value.name());
    }

    private static <T extends Enum<T>> T readEnum(ObjectInputStream in, Class<T> enumType) throws IOException {
        String value = in.readUTF();
        return Enum.valueOf(enumType, value);
    }
}

