/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.pagecursor;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.pagecursor.PageCursorSerializer;
import org.opentripplanner.model.plan.pagecursor.PageType;
import org.opentripplanner.util.lang.ToStringBuilder;

public class PageCursor {
    public final PageType type;
    public final SortOrder originalSortOrder;
    public final Instant earliestDepartureTime;
    public final Instant latestArrivalTime;
    public final Duration searchWindow;

    PageCursor(PageType type, SortOrder originalSortOrder, Instant earliestDepartureTime, Instant latestArrivalTime, Duration searchWindow) {
        this.type = type;
        this.searchWindow = searchWindow;
        this.earliestDepartureTime = earliestDepartureTime;
        this.latestArrivalTime = latestArrivalTime;
        this.originalSortOrder = originalSortOrder;
    }

    @Nullable
    public static PageCursor decode(String cursor) {
        return PageCursorSerializer.decode(cursor);
    }

    public String toString() {
        return ToStringBuilder.of(PageCursor.class).addEnum("type", this.type).addEnum("sortOrder", this.originalSortOrder).addDateTime("edt", this.earliestDepartureTime).addDateTime("lat", this.latestArrivalTime).addDuration("searchWindow", this.searchWindow).toString();
    }

    @Nullable
    public String encode() {
        return PageCursorSerializer.encode(this);
    }
}

