/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingEntrance;

public class VehicleParkingWithEntrance {
    private final VehicleParking vehicleParking;
    private final VehicleParkingEntrance entrance;
    private final boolean realtime;

    VehicleParkingWithEntrance(VehicleParking vehicleParking, VehicleParkingEntrance entrance, boolean realtime) {
        this.vehicleParking = vehicleParking;
        this.entrance = entrance;
        this.realtime = realtime;
    }

    public static VehicleParkingWithEntranceBuilder builder() {
        return new VehicleParkingWithEntranceBuilder();
    }

    public VehicleParking getVehicleParking() {
        return this.vehicleParking;
    }

    public VehicleParkingEntrance getEntrance() {
        return this.entrance;
    }

    public boolean isRealtime() {
        return this.realtime;
    }

    public static class VehicleParkingWithEntranceBuilder {
        private VehicleParking vehicleParking;
        private VehicleParkingEntrance entrance;
        private boolean realtime;

        VehicleParkingWithEntranceBuilder() {
        }

        public VehicleParkingWithEntranceBuilder vehicleParking(VehicleParking vehicleParking) {
            this.vehicleParking = vehicleParking;
            return this;
        }

        public VehicleParkingWithEntranceBuilder entrance(VehicleParkingEntrance entrance) {
            this.entrance = entrance;
            return this;
        }

        public VehicleParkingWithEntranceBuilder realtime(boolean realtime) {
            this.realtime = realtime;
            return this;
        }

        public VehicleParkingWithEntrance build() {
            return new VehicleParkingWithEntrance(this.vehicleParking, this.entrance, this.realtime);
        }
    }
}

