/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opentripplanner.ext.flex.FlexibleTransitLeg;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.plan.ItinerariesCalculateLegTotals;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.routing.core.ItineraryFares;
import org.opentripplanner.transit.raptor.api.path.PathStringBuilder;
import org.opentripplanner.util.lang.DoubleUtils;
import org.opentripplanner.util.lang.ToStringBuilder;

public class Itinerary {
    private final Duration duration;
    private final Duration transitDuration;
    private final int numberOfTransfers;
    private final Duration waitingDuration;
    private final double nonTransitDistanceMeters;
    private final boolean walkOnly;
    private final boolean streetOnly;
    private final Duration nonTransitDuration;
    private Double elevationLost = 0.0;
    private Double elevationGained = 0.0;
    private int generalizedCost = -1;
    private int waitTimeOptimizedCost = -1;
    private int transferPriorityCost = -1;
    private boolean tooSloped = false;
    private Double maxSlope = null;
    private boolean arrivedAtDestinationWithRentedVehicle = false;
    private Float accessibilityScore;
    private final List<SystemNotice> systemNotices = new ArrayList<SystemNotice>();
    private List<Leg> legs;
    private ItineraryFares fare = ItineraryFares.empty();

    public Itinerary(List<Leg> legs) {
        this.setLegs(legs);
        ItinerariesCalculateLegTotals totals = new ItinerariesCalculateLegTotals(legs);
        this.duration = totals.totalDuration;
        this.numberOfTransfers = totals.transfers();
        this.transitDuration = totals.transitDuration;
        this.nonTransitDuration = totals.nonTransitDuration;
        this.nonTransitDistanceMeters = DoubleUtils.roundTo2Decimals(totals.nonTransitDistanceMeters);
        this.waitingDuration = totals.walkingDuration;
        this.walkOnly = totals.walkOnly;
        this.streetOnly = totals.streetOnly;
        this.setElevationGained(totals.totalElevationGained);
        this.setElevationLost(totals.totalElevationLost);
    }

    public static String toStr(List<Itinerary> list) {
        return list.stream().map(Itinerary::toStr).collect(Collectors.joining(", "));
    }

    public ZonedDateTime startTime() {
        return this.firstLeg().getStartTime();
    }

    public ZonedDateTime endTime() {
        return this.lastLeg().getEndTime();
    }

    public int departureDelay() {
        return this.firstLeg().getDepartureDelay();
    }

    public int arrivalDelay() {
        return this.lastLeg().getArrivalDelay();
    }

    public Duration effectiveDuration() {
        return this.getTransitDuration().plus(this.getNonTransitDuration());
    }

    public double distanceMeters() {
        return this.getLegs().stream().mapToDouble(Leg::getDistanceMeters).sum();
    }

    public boolean isWalkingAllTheWay() {
        return this.isWalkOnly();
    }

    public boolean isOnStreetAllTheWay() {
        return this.isStreetOnly();
    }

    public boolean hasTransit() {
        return this.legs.stream().anyMatch(l -> l instanceof ScheduledTransitLeg || l instanceof FlexibleTransitLeg);
    }

    public Leg firstLeg() {
        return this.getLegs().get(0);
    }

    public Leg lastLeg() {
        return this.getLegs().get(this.getLegs().size() - 1);
    }

    public Optional<Leg> firstTransitLeg() {
        return this.getLegs().stream().filter(TransitLeg.class::isInstance).findFirst();
    }

    public void flagForDeletion(SystemNotice notice) {
        this.systemNotices.add(notice);
    }

    public void removeDeletionFlags() {
        this.systemNotices.clear();
    }

    public boolean isFlaggedForDeletion() {
        return !this.getSystemNotices().isEmpty();
    }

    public Itinerary withTimeShiftToStartAt(ZonedDateTime afterTime) {
        Duration duration = Duration.between(this.firstLeg().getStartTime(), afterTime);
        List<Leg> timeShiftedLegs = this.getLegs().stream().map(leg -> leg.withTimeShift(duration)).collect(Collectors.toList());
        Itinerary newItin = new Itinerary(timeShiftedLegs);
        newItin.setGeneralizedCost(this.getGeneralizedCost());
        return newItin;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return ToStringBuilder.of(Itinerary.class).addStr("from", this.firstLeg().getFrom().toStringShort()).addStr("to", this.lastLeg().getTo().toStringShort()).addTime("start", this.firstLeg().getStartTime()).addTime("end", this.lastLeg().getEndTime()).addNum("nTransfers", (Number)this.numberOfTransfers, -1).addDuration("duration", this.duration).addNum("generalizedCost", this.generalizedCost).addDuration("nonTransitTime", this.nonTransitDuration).addDuration("transitTime", this.transitDuration).addDuration("waitingTime", this.waitingDuration).addNum("nonTransitDistance", (Number)this.nonTransitDistanceMeters, "m").addBool("tooSloped", this.tooSloped).addNum("elevationLost", (Number)this.elevationLost, 0.0).addNum("elevationGained", (Number)this.elevationGained, 0.0).addCol("legs", this.legs).addObj("fare", this.fare).toString();
    }

    public String toStr() {
        PathStringBuilder buf = new PathStringBuilder(null);
        buf.stop(this.firstLeg().getFrom().name.toString());
        for (Leg leg : this.legs) {
            buf.sep();
            if (leg.isWalkingLeg()) {
                buf.walk((int)leg.getDuration().toSeconds());
            } else if (leg instanceof TransitLeg) {
                TransitLeg transitLeg = (TransitLeg)leg;
                buf.transit(transitLeg.getMode().name(), transitLeg.getTrip().logName(), transitLeg.getStartTime(), transitLeg.getEndTime());
            } else if (leg instanceof StreetLeg) {
                StreetLeg streetLeg = (StreetLeg)leg;
                buf.street(streetLeg.getMode().name(), leg.getStartTime(), leg.getEndTime());
            }
            buf.sep();
            buf.stop(leg.getTo().name.toString());
        }
        buf.space().append(String.format(Locale.ROOT, "[ $%d ]", this.generalizedCost));
        return buf.toString();
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Duration getTransitDuration() {
        return this.transitDuration;
    }

    public int getNumberOfTransfers() {
        return this.numberOfTransfers;
    }

    public Duration getWaitingDuration() {
        return this.waitingDuration;
    }

    public double getNonTransitDistanceMeters() {
        return this.nonTransitDistanceMeters;
    }

    public boolean isWalkOnly() {
        return this.walkOnly;
    }

    public boolean isStreetOnly() {
        return this.streetOnly;
    }

    public List<SystemNotice> getSystemNotices() {
        return List.copyOf(this.systemNotices);
    }

    public List<Leg> getLegs() {
        return this.legs;
    }

    public TransitLeg getTransitLeg(int index) {
        return (TransitLeg)this.legs.get(index);
    }

    public StreetLeg getStreetLeg(int index) {
        return (StreetLeg)this.legs.get(index);
    }

    public void setLegs(List<Leg> legs) {
        this.legs = List.copyOf(legs);
    }

    public Float getAccessibilityScore() {
        return this.accessibilityScore;
    }

    public void setAccessibilityScore(Float accessibilityScore) {
        this.accessibilityScore = accessibilityScore;
    }

    public Duration getNonTransitDuration() {
        return this.nonTransitDuration;
    }

    public Double getElevationLost() {
        return this.elevationLost;
    }

    public void setElevationLost(Double elevationLost) {
        this.elevationLost = DoubleUtils.roundTo2Decimals(elevationLost);
    }

    public Double getElevationGained() {
        return this.elevationGained;
    }

    public void setElevationGained(Double elevationGained) {
        this.elevationGained = DoubleUtils.roundTo2Decimals(elevationGained);
    }

    public int getGeneralizedCost() {
        return this.generalizedCost;
    }

    public void setGeneralizedCost(int generalizedCost) {
        this.generalizedCost = generalizedCost;
    }

    public int getWaitTimeOptimizedCost() {
        return this.waitTimeOptimizedCost;
    }

    public void setWaitTimeOptimizedCost(int waitTimeOptimizedCost) {
        this.waitTimeOptimizedCost = waitTimeOptimizedCost;
    }

    public int getTransferPriorityCost() {
        return this.transferPriorityCost;
    }

    public void setTransferPriorityCost(int transferPriorityCost) {
        this.transferPriorityCost = transferPriorityCost;
    }

    public boolean isTooSloped() {
        return this.tooSloped;
    }

    public void setTooSloped(boolean tooSloped) {
        this.tooSloped = tooSloped;
    }

    public Double getMaxSlope() {
        return this.maxSlope;
    }

    public void setMaxSlope(Double maxSlope) {
        this.maxSlope = DoubleUtils.roundTo2Decimals(maxSlope);
    }

    public boolean isArrivedAtDestinationWithRentedVehicle() {
        return this.arrivedAtDestinationWithRentedVehicle;
    }

    public void setArrivedAtDestinationWithRentedVehicle(boolean arrivedAtDestinationWithRentedVehicle) {
        this.arrivedAtDestinationWithRentedVehicle = arrivedAtDestinationWithRentedVehicle;
    }

    public int getLegIndex(Leg leg) {
        int index = this.legs.indexOf(leg);
        if (index > -1) {
            return index;
        }
        for (int i = 0; i < this.legs.size() - 1; ++i) {
            Leg currentLeg = this.legs.get(i);
            if (!currentLeg.getFrom().sameLocation(leg.getFrom()) || !currentLeg.getTo().sameLocation(leg.getTo())) continue;
            return i;
        }
        return -1;
    }

    public ItineraryFares getFares() {
        return this.fare;
    }

    public void setFare(ItineraryFares fare) {
        this.fare = fare;
    }

    public List<ScheduledTransitLeg> getScheduledTransitLegs() {
        return this.getLegs().stream().filter(ScheduledTransitLeg.class::isInstance).map(ScheduledTransitLeg.class::cast).toList();
    }
}

