/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.Duration;
import java.util.List;
import org.opentripplanner.model.plan.Leg;

class ItinerariesCalculateLegTotals {
    Duration totalDuration = Duration.ZERO;
    Duration transitDuration = Duration.ZERO;
    int nTransitLegs = 0;
    Duration nonTransitDuration = Duration.ZERO;
    double nonTransitDistanceMeters = 0.0;
    Duration walkingDuration;
    boolean walkOnly = true;
    boolean streetOnly = true;
    double totalElevationGained = 0.0;
    double totalElevationLost = 0.0;

    public ItinerariesCalculateLegTotals(List<Leg> legs) {
        if (legs.isEmpty()) {
            return;
        }
        this.calculate(legs);
    }

    int transfers() {
        return this.nTransitLegs == 0 ? 0 : this.nTransitLegs - 1;
    }

    private void calculate(List<Leg> legs) {
        this.totalDuration = Duration.between(legs.get(0).getStartTime(), legs.get(legs.size() - 1).getEndTime());
        for (Leg leg : legs) {
            Duration dt = leg.getDuration();
            if (leg.isTransitLeg()) {
                this.transitDuration = this.transitDuration.plus(dt);
                if (!leg.isInterlinedWithPreviousLeg().booleanValue()) {
                    ++this.nTransitLegs;
                }
            } else if (leg.isStreetLeg()) {
                this.nonTransitDuration = this.nonTransitDuration.plus(dt);
                this.nonTransitDistanceMeters += leg.getDistanceMeters();
            }
            if (!leg.isWalkingLeg()) {
                this.walkOnly = false;
            }
            if (!leg.isStreetLeg()) {
                this.streetOnly = false;
            }
            if (leg.getElevationGained() == null || leg.getElevationLost() == null) continue;
            this.totalElevationGained += leg.getElevationGained().doubleValue();
            this.totalElevationLost += leg.getElevationLost().doubleValue();
        }
        this.walkingDuration = this.totalDuration.minus(this.transitDuration).minus(this.nonTransitDuration);
    }
}

