/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.openinghours;

import java.time.Duration;
import java.time.Instant;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;

public class OHSearchContext {
    private final Instant searchStartTime;
    private final Instant searchEndTime;

    public OHSearchContext(Instant searchStartTime, Duration maxJourneyDuration) {
        if (maxJourneyDuration.isNegative()) {
            this.searchStartTime = searchStartTime.plus(maxJourneyDuration);
            this.searchEndTime = searchStartTime;
        } else {
            this.searchStartTime = searchStartTime;
            this.searchEndTime = searchStartTime.plus(maxJourneyDuration);
        }
    }

    public boolean isOpen(OHCalendar calendar, long timeEpochSecond) {
        return calendar.isOpen(timeEpochSecond);
    }

    public boolean canEnter(OHCalendar calendar, long epochSecond) {
        return this.isOpen(calendar, epochSecond);
    }

    public boolean canExit(OHCalendar calendar, long epochSecond) {
        return this.isOpen(calendar, epochSecond);
    }
}

