/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.impl;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceCalendar;
import org.opentripplanner.model.calendar.ServiceCalendarDate;
import org.opentripplanner.model.calendar.impl.MultipleCalendarsForServiceIdException;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarServiceDataFactoryImpl {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarServiceDataFactoryImpl.class);
    private final Map<FeedScopedId, List<ServiceCalendarDate>> calendarDatesByServiceId;
    private final Map<FeedScopedId, List<ServiceCalendar>> calendarsByServiceId;
    private final Set<FeedScopedId> serviceIds;

    private CalendarServiceDataFactoryImpl(Collection<ServiceCalendarDate> calendarDates, Collection<ServiceCalendar> serviceCalendars) {
        this.calendarDatesByServiceId = calendarDates.stream().collect(Collectors.groupingBy(ServiceCalendarDate::getServiceId));
        this.calendarsByServiceId = serviceCalendars.stream().collect(Collectors.groupingBy(ServiceCalendar::getServiceId));
        this.serviceIds = CalendarServiceDataFactoryImpl.merge(this.calendarDatesByServiceId.keySet(), this.calendarsByServiceId.keySet());
    }

    public static CalendarServiceData createCalendarServiceData(Collection<ServiceCalendarDate> calendarDates, Collection<ServiceCalendar> serviceCalendars) {
        return new CalendarServiceDataFactoryImpl(calendarDates, serviceCalendars).createData();
    }

    static <T> Set<T> merge(Collection<T> set1, Collection<T> set2) {
        HashSet<T> newSet = new HashSet<T>();
        newSet.addAll(set1);
        newSet.addAll(set2);
        return newSet;
    }

    private CalendarServiceData createData() {
        CalendarServiceData data = new CalendarServiceData();
        int index = 0;
        for (FeedScopedId serviceId : this.serviceIds) {
            LOG.debug("serviceId={} ({}/{})", new Object[]{serviceId, ++index, this.serviceIds.size()});
            Set<LocalDate> activeDates = this.getServiceDatesForServiceId(serviceId);
            ArrayList<LocalDate> serviceDates = new ArrayList<LocalDate>(activeDates);
            Collections.sort(serviceDates);
            data.putServiceDatesForServiceId(serviceId, serviceDates);
        }
        return data;
    }

    private Set<LocalDate> getServiceDatesForServiceId(FeedScopedId serviceId) {
        List<ServiceCalendarDate> dates;
        HashSet<LocalDate> activeDates = new HashSet<LocalDate>();
        ServiceCalendar c = this.findCalendarForServiceId(serviceId);
        if (c != null) {
            this.addDatesFromCalendar(c, activeDates);
        }
        if ((dates = this.calendarDatesByServiceId.get(serviceId)) != null) {
            for (ServiceCalendarDate cd : dates) {
                this.addAndRemoveDatesFromCalendarDate(cd, activeDates);
            }
        }
        return activeDates;
    }

    private ServiceCalendar findCalendarForServiceId(FeedScopedId serviceId) {
        List<ServiceCalendar> calendars = this.calendarsByServiceId.get(serviceId);
        if (calendars == null || calendars.isEmpty()) {
            return null;
        }
        if (calendars.size() == 1) {
            return calendars.get(0);
        }
        throw new MultipleCalendarsForServiceIdException(serviceId);
    }

    private void addDatesFromCalendar(ServiceCalendar calendar, Set<LocalDate> activeDates) {
        LocalDate startDate = calendar.getPeriod().getStart();
        LocalDate endDate = calendar.getPeriod().getEnd();
        LocalDate date = startDate;
        while (!date.isAfter(endDate)) {
            block16: {
                switch (date.getDayOfWeek()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case MONDAY: {
                        if (calendar.getMonday() == 1) {
                            break;
                        }
                        break block16;
                    }
                    case TUESDAY: {
                        if (calendar.getTuesday() == 1) {
                            break;
                        }
                        break block16;
                    }
                    case WEDNESDAY: {
                        if (calendar.getWednesday() == 1) {
                            break;
                        }
                        break block16;
                    }
                    case THURSDAY: {
                        if (calendar.getThursday() == 1) {
                            break;
                        }
                        break block16;
                    }
                    case FRIDAY: {
                        if (calendar.getFriday() == 1) {
                            break;
                        }
                        break block16;
                    }
                    case SATURDAY: {
                        if (calendar.getSaturday() == 1) {
                            break;
                        }
                        break block16;
                    }
                    case SUNDAY: {
                        if (calendar.getSunday() != 1) break block16;
                    }
                }
                this.addServiceDate(activeDates, date);
            }
            date = date.plusDays(1L);
        }
    }

    private void addAndRemoveDatesFromCalendarDate(ServiceCalendarDate calendarDate, Set<LocalDate> activeDates) {
        LocalDate serviceDate = calendarDate.getDate();
        switch (calendarDate.getExceptionType()) {
            case 1: {
                this.addServiceDate(activeDates, serviceDate);
                break;
            }
            case 2: {
                activeDates.remove(serviceDate);
                break;
            }
            default: {
                LOG.warn("unknown CalendarDate exception type: {}", (Object)calendarDate.getExceptionType());
            }
        }
    }

    private void addServiceDate(Set<LocalDate> activeDates, LocalDate serviceDate) {
        activeDates.add(serviceDate);
    }
}

