/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import com.google.transit.realtime.GtfsRealtime;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opentripplanner.model.TripTimesPatch;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.updater.GtfsRealtimeMapper;
import org.opentripplanner.updater.trip.BackwardsDelayPropagationType;
import org.opentripplanner.util.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timetable
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Timetable.class);
    private final TripPattern pattern;
    private final List<TripTimes> tripTimes = new ArrayList<TripTimes>();
    private final List<FrequencyEntry> frequencyEntries = new ArrayList<FrequencyEntry>();
    private final LocalDate serviceDate;

    public Timetable(TripPattern pattern) {
        this.pattern = pattern;
        this.serviceDate = null;
    }

    Timetable(Timetable tt, LocalDate serviceDate) {
        this.tripTimes.addAll(tt.tripTimes);
        this.serviceDate = serviceDate;
        this.pattern = tt.pattern;
    }

    public int getTripIndex(FeedScopedId tripId) {
        int ret = 0;
        for (TripTimes tt : this.tripTimes) {
            if (tt.getTrip().getId().equals(tripId)) {
                return ret;
            }
            ++ret;
        }
        return -1;
    }

    public int getTripIndex(String tripId) {
        int ret = 0;
        for (TripTimes tt : this.tripTimes) {
            if (tt.getTrip().getId().getId().equals(tripId)) {
                return ret;
            }
            ++ret;
        }
        return -1;
    }

    public TripTimes getTripTimes(int tripIndex) {
        return this.tripTimes.get(tripIndex);
    }

    public TripTimes getTripTimes(Trip trip) {
        for (TripTimes tt : this.tripTimes) {
            if (tt.getTrip() != trip) continue;
            return tt;
        }
        return null;
    }

    public TripTimes getTripTimes(FeedScopedId tripId) {
        for (TripTimes tt : this.tripTimes) {
            if (tt.getTrip().getId() != tripId) continue;
            return tt;
        }
        return null;
    }

    public TripTimes setTripTimes(int tripIndex, TripTimes tt) {
        return this.tripTimes.set(tripIndex, tt);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Result<TripTimesPatch, UpdateError> createUpdatedTripTimes(GtfsRealtime.TripUpdate tripUpdate, ZoneId timeZone, LocalDate updateServiceDate, BackwardsDelayPropagationType backwardsDelayPropagationType) {
        GtfsRealtime.VehicleDescriptor vehicleDescriptor;
        Result<?, UpdateError> result;
        Result<TripTimesPatch, UpdateError> invalidInput = Result.failure(UpdateError.noTripId(UpdateError.UpdateErrorType.INVALID_INPUT_STRUCTURE));
        if (tripUpdate == null) {
            LOG.debug("A null TripUpdate pointer was passed to the Timetable class update method.");
            return invalidInput;
        }
        if (!tripUpdate.hasTrip()) {
            LOG.debug("TripUpdate object has no TripDescriptor field.");
            return invalidInput;
        }
        GtfsRealtime.TripDescriptor tripDescriptor = tripUpdate.getTrip();
        if (!tripDescriptor.hasTripId()) {
            LOG.debug("TripDescriptor object has no TripId field");
            Result.failure(UpdateError.noTripId(UpdateError.UpdateErrorType.TRIP_NOT_FOUND));
        }
        String tripId = tripDescriptor.getTripId();
        FeedScopedId feedScopedTripId = new FeedScopedId(this.getPattern().getFeedId(), tripId);
        int tripIndex = this.getTripIndex(tripId);
        if (tripIndex == -1) {
            LOG.debug("tripId {} not found in pattern.", (Object)tripId);
            return Result.failure(new UpdateError(feedScopedTripId, UpdateError.UpdateErrorType.TRIP_NOT_FOUND_IN_PATTERN));
        }
        LOG.trace("tripId {} found at index {} in timetable.", (Object)tripId, (Object)tripIndex);
        TripTimes newTimes = new TripTimes(this.getTripTimes(tripIndex));
        ArrayList<Integer> skippedStopIndices = new ArrayList<Integer>();
        Iterator<GtfsRealtime.TripUpdate.StopTimeUpdate> updates = tripUpdate.getStopTimeUpdateList().iterator();
        if (!updates.hasNext()) {
            LOG.warn("Won't apply zero-length trip update to trip {}.", (Object)tripId);
            return Result.failure(new UpdateError(feedScopedTripId, UpdateError.UpdateErrorType.TOO_FEW_STOPS));
        }
        GtfsRealtime.TripUpdate.StopTimeUpdate update = updates.next();
        int numStops = newTimes.getNumStops();
        Integer delay = null;
        Integer firstUpdatedIndex = null;
        long today = ServiceDateUtils.asStartOfService(updateServiceDate, timeZone).toEpochSecond();
        for (int i = 0; i < numStops; ++i) {
            block31: {
                block30: {
                    block35: {
                        GtfsRealtime.TripUpdate.StopTimeEvent departure;
                        block29: {
                            block34: {
                                GtfsRealtime.TripUpdate.StopTimeEvent arrival;
                                block33: {
                                    GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship scheduleRelationship;
                                    block32: {
                                        boolean match = false;
                                        if (update != null) {
                                            if (update.hasStopSequence()) {
                                                match = update.getStopSequence() == newTimes.getOriginalGtfsStopSequence(i);
                                            } else if (update.hasStopId()) {
                                                match = this.pattern.getStop(i).getId().getId().equals(update.getStopId());
                                            }
                                        }
                                        if (!match) break block31;
                                        GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship scheduleRelationship2 = scheduleRelationship = update.hasScheduleRelationship() ? update.getScheduleRelationship() : GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SCHEDULED;
                                        if (scheduleRelationship != GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED) break block32;
                                        skippedStopIndices.add(i);
                                        newTimes.setCancelled(i);
                                        int delayOrZero = delay != null ? delay : 0;
                                        newTimes.updateArrivalDelay(i, delayOrZero);
                                        newTimes.updateDepartureDelay(i, delayOrZero);
                                        break block30;
                                    }
                                    if (scheduleRelationship != GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA) break block33;
                                    newTimes.updateArrivalDelay(i, 0);
                                    newTimes.updateDepartureDelay(i, 0);
                                    delay = 0;
                                    newTimes.setNoData(i);
                                    break block30;
                                }
                                if (!update.hasArrival()) break block34;
                                if (firstUpdatedIndex == null) {
                                    firstUpdatedIndex = i;
                                }
                                if ((arrival = update.getArrival()).hasDelay()) {
                                    delay = arrival.getDelay();
                                    if (arrival.hasTime()) {
                                        newTimes.updateArrivalTime(i, (int)(arrival.getTime() - today));
                                        break block29;
                                    } else {
                                        newTimes.updateArrivalDelay(i, delay);
                                    }
                                    break block29;
                                } else {
                                    if (!arrival.hasTime()) {
                                        LOG.error("Arrival time at index {} is erroneous.", (Object)i);
                                        return Result.failure(new UpdateError(feedScopedTripId, UpdateError.UpdateErrorType.INVALID_ARRIVAL_TIME));
                                    }
                                    newTimes.updateArrivalTime(i, (int)(arrival.getTime() - today));
                                    delay = newTimes.getArrivalDelay(i);
                                }
                                break block29;
                            }
                            if (delay != null) {
                                newTimes.updateArrivalDelay(i, delay);
                            }
                        }
                        if (!update.hasDeparture()) break block35;
                        if (firstUpdatedIndex == null) {
                            firstUpdatedIndex = i;
                        }
                        if ((departure = update.getDeparture()).hasDelay()) {
                            delay = departure.getDelay();
                            if (departure.hasTime()) {
                                newTimes.updateDepartureTime(i, (int)(departure.getTime() - today));
                                break block30;
                            } else {
                                newTimes.updateDepartureDelay(i, delay);
                            }
                            break block30;
                        } else {
                            if (!departure.hasTime()) {
                                LOG.error("Departure time at index {} is erroneous.", (Object)i);
                                return Result.failure(new UpdateError(feedScopedTripId, UpdateError.UpdateErrorType.INVALID_DEPARTURE_TIME));
                            }
                            newTimes.updateDepartureTime(i, (int)(departure.getTime() - today));
                            delay = newTimes.getDepartureDelay(i);
                        }
                        break block30;
                    }
                    if (delay != null) {
                        newTimes.updateDepartureDelay(i, delay);
                    }
                }
                if (updates.hasNext()) {
                    update = updates.next();
                    continue;
                }
                update = null;
                continue;
            }
            if (delay == null) continue;
            newTimes.updateArrivalDelay(i, delay);
            newTimes.updateDepartureDelay(i, delay);
        }
        if (update != null) {
            LOG.debug("Part of a TripUpdate object could not be applied successfully to trip {}.", (Object)tripId);
            return Result.failure(new UpdateError(feedScopedTripId, UpdateError.UpdateErrorType.INVALID_STOP_SEQUENCE));
        }
        if (firstUpdatedIndex != null && firstUpdatedIndex > 0 && (backwardsDelayPropagationType == BackwardsDelayPropagationType.REQUIRED_NO_DATA && newTimes.adjustTimesBeforeWhenRequired(firstUpdatedIndex, true) || backwardsDelayPropagationType == BackwardsDelayPropagationType.REQUIRED && newTimes.adjustTimesBeforeWhenRequired(firstUpdatedIndex, false) || backwardsDelayPropagationType == BackwardsDelayPropagationType.ALWAYS && newTimes.adjustTimesBeforeAlways(firstUpdatedIndex))) {
            LOG.debug("Propagated delay from stop index {} backwards on trip {}.", (Object)firstUpdatedIndex, (Object)tripId);
        }
        if ((result = newTimes.validateNonIncreasingTimes()).isFailure()) {
            LOG.debug("TripTimes are non-increasing after applying GTFS-RT delay propagation to trip {} after stop index {}.", (Object)tripId, (Object)result.failureValue().stopIndex());
            return Result.failure(result.failureValue());
        }
        if (tripUpdate.hasVehicle() && (vehicleDescriptor = tripUpdate.getVehicle()).hasWheelchairAccessible()) {
            GtfsRealtimeMapper.mapWheelchairAccessible(vehicleDescriptor.getWheelchairAccessible()).ifPresent(newTimes::updateWheelchairAccessibility);
        }
        LOG.trace("A valid TripUpdate object was applied to trip {} using the Timetable class update method.", (Object)tripId);
        return Result.success(new TripTimesPatch(newTimes, skippedStopIndices));
    }

    public void addTripTimes(TripTimes tt) {
        this.tripTimes.add(tt);
    }

    public void addFrequencyEntry(FrequencyEntry freq) {
        this.frequencyEntries.add(freq);
    }

    public boolean isValidFor(LocalDate serviceDate) {
        return this.serviceDate == null || this.serviceDate.equals(serviceDate);
    }

    public void setServiceCodes(Map<FeedScopedId, Integer> serviceCodes) {
        for (TripTimes tt : this.tripTimes) {
            tt.setServiceCode(serviceCodes.get(tt.getTrip().getServiceId()));
        }
        for (FrequencyEntry freq : this.frequencyEntries) {
            TripTimes tt = freq.tripTimes;
            tt.setServiceCode(serviceCodes.get(tt.getTrip().getServiceId()));
        }
    }

    public TripPattern getPattern() {
        return this.pattern;
    }

    public List<TripTimes> getTripTimes() {
        return this.tripTimes;
    }

    public List<FrequencyEntry> getFrequencyEntries() {
        return this.frequencyEntries;
    }

    public LocalDate getServiceDate() {
        return this.serviceDate;
    }

    public Direction getDirection() {
        return Optional.ofNullable(this.getRepresentativeTripTimes()).map(TripTimes::getTrip).map(Trip::getDirection).orElse(Direction.UNKNOWN);
    }

    public TripTimes getRepresentativeTripTimes() {
        if (!this.getTripTimes().isEmpty()) {
            return this.getTripTimes(0);
        }
        if (!this.getFrequencyEntries().isEmpty()) {
            return this.getFrequencyEntries().get((int)0).tripTimes;
        }
        return null;
    }
}

