/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector;

import java.awt.Color;
import org.opentripplanner.inspector.DefaultScalarColorPalette;
import org.opentripplanner.inspector.EdgeVertexTileRenderer;
import org.opentripplanner.inspector.ScalarColorPalette;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.IntersectionVertex;

public class WalkSafetyEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private final ScalarColorPalette palette = new DefaultScalarColorPalette(1.0, 3.0, 10.0);

    @Override
    public boolean renderEdge(Edge e, EdgeVertexTileRenderer.EdgeVisualAttributes attrs) {
        if (e instanceof StreetEdge) {
            StreetEdge pse = (StreetEdge)e;
            if (pse.getPermission().allows(TraverseMode.WALK)) {
                double walkSafety = pse.getWalkSafetyFactor();
                attrs.color = this.palette.getColor(walkSafety);
                attrs.label = String.format("%.02f", walkSafety);
            } else {
                attrs.color = Color.LIGHT_GRAY;
                attrs.label = "no walking";
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean renderVertex(Vertex v, EdgeVertexTileRenderer.VertexVisualAttributes attrs) {
        if (!(v instanceof IntersectionVertex)) {
            return false;
        }
        attrs.color = Color.DARK_GRAY;
        return true;
    }

    @Override
    public String getName() {
        return "Walk safety";
    }
}

