/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector;

import java.awt.Color;
import org.opentripplanner.inspector.EdgeVertexTileRenderer;
import org.opentripplanner.routing.edgetype.PathwayEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StationElement;

public class PathwayEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    @Override
    public boolean renderEdge(Edge e, EdgeVertexTileRenderer.EdgeVisualAttributes attrs) {
        if (!(e instanceof PathwayEdge)) {
            return false;
        }
        PathwayEdge pwe = (PathwayEdge)e;
        StringBuilder sb = new StringBuilder();
        if (!pwe.hasBogusName()) {
            sb.append("name=").append(pwe.getName()).append(", ");
        }
        if (pwe.getDistanceMeters() != 0.0) {
            sb.append("distance=").append(Math.round(pwe.getDistanceMeters())).append(", ");
        }
        if (pwe.getDistanceIndependentTime() != 0) {
            sb.append("time=").append(pwe.getDistanceIndependentTime()).append(", ");
        }
        if (pwe.getSteps() != 0) {
            sb.append("steps=").append(pwe.getSteps()).append(", ");
        }
        if (!sb.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        attrs.label = sb.toString();
        switch (pwe.getMode()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WALKWAY: {
                Color color = new Color(145, 217, 38);
                break;
            }
            case STAIRS: {
                Color color = Color.CYAN;
                break;
            }
            case MOVING_SIDEWALK: {
                Color color = Color.GREEN;
                break;
            }
            case ESCALATOR: {
                Color color = Color.BLUE;
                break;
            }
            case ELEVATOR: {
                Color color = Color.PINK;
                break;
            }
            case FARE_GATE: {
                Color color = Color.RED;
                break;
            }
            case EXIT_GATE: {
                Color color = Color.MAGENTA;
                break;
            }
            case UNKNOWN: {
                Color color = attrs.color = Color.GRAY;
            }
        }
        if (!pwe.isWheelchairAccessible()) {
            attrs.color = attrs.color.darker();
        }
        return true;
    }

    @Override
    public boolean renderVertex(Vertex v, EdgeVertexTileRenderer.VertexVisualAttributes attrs) {
        RegularStop stop;
        StationElement stationElement = v.getStationElement();
        if (stationElement == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(stationElement.getName());
        if (stationElement instanceof RegularStop && (stop = (RegularStop)stationElement).getPlatformCode() != null) {
            sb.append(" [").append(stop.getPlatformCode()).append("]");
        }
        if (stationElement.getCode() != null) {
            sb.append(" (").append(stationElement.getCode()).append(")");
        }
        attrs.label = sb.toString();
        attrs.color = switch (stationElement.getClass().getSimpleName()) {
            case "Stop" -> Color.ORANGE;
            case "PathwayNode" -> new Color(217, 38, 145);
            case "Entrance" -> new Color(38, 184, 217);
            case "BoardingArea" -> Color.PINK;
            default -> Color.LIGHT_GRAY;
        };
        return true;
    }

    @Override
    public String getName() {
        return "Pathways";
    }
}

