/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector;

import java.awt.Color;
import org.opentripplanner.inspector.EdgeVertexTileRenderer;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;

public class NoThruTrafficEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private static final Color[] colors = new Color[]{new Color(200, 200, 200), new Color(200, 200, 0), new Color(0, 200, 200), new Color(0, 200, 0), new Color(0, 0, 200), new Color(200, 100, 0), new Color(200, 0, 200), new Color(200, 0, 0)};

    @Override
    public boolean renderEdge(Edge e, EdgeVertexTileRenderer.EdgeVisualAttributes attrs) {
        if (e instanceof StreetEdge) {
            StreetEdge pse = (StreetEdge)e;
            int colorIndex = 0;
            attrs.label = "";
            if (pse.isWalkNoThruTraffic()) {
                attrs.label = " walk ";
                ++colorIndex;
            }
            if (pse.isBicycleNoThruTraffic()) {
                attrs.label = attrs.label + " bike";
                colorIndex += 2;
            }
            if (pse.isMotorVehicleNoThruTraffic()) {
                attrs.label = attrs.label + " car";
                colorIndex += 4;
            }
            attrs.color = colors[colorIndex];
            if (!attrs.label.equals("")) {
                attrs.label = "No" + attrs.label + " thru traffic";
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean renderVertex(Vertex v, EdgeVertexTileRenderer.VertexVisualAttributes attrs) {
        return false;
    }

    @Override
    public String getName() {
        return "No thru traffic";
    }
}

